/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.oauth;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.keycloak.servlet.ServletOAuthClient;
import org.keycloak.servlet.ServletOAuthClientBuilder;

public class Bootstrap
implements ServletContextListener {
    private ServletOAuthClient client;

    public void contextInitialized(ServletContextEvent sce) {
        this.client = new ServletOAuthClient();
        ServletContext context = sce.getServletContext();
        this.configureClient(context);
        context.setAttribute(ServletOAuthClient.class.getName(), (Object)this.client);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.client.stop();
    }

    private void configureClient(ServletContext context) {
        InputStream is = null;
        String path = context.getInitParameter("keycloak.config.file");
        if (path == null) {
            is = context.getResourceAsStream("/WEB-INF/keycloak.json");
        } else {
            try {
                is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.client = ServletOAuthClientBuilder.build((InputStream)is);
    }
}

