/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.common.util.UriUtils;
import org.keycloak.example.oauth.ProductDatabaseClient;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.servlet.ServletOAuthClient;
import org.keycloak.util.JsonSerialization;

public class ProductDatabaseClient {
    public static void redirect(HttpServletRequest request, HttpServletResponse response) {
        ServletOAuthClient oAuthClient = (ServletOAuthClient)request.getServletContext().getAttribute(ServletOAuthClient.class.getName());
        try {
            oAuthClient.redirectRelative("pull_data.jsp", request, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static AccessTokenResponse getTokenResponse(HttpServletRequest request) {
        ServletOAuthClient oAuthClient = (ServletOAuthClient)request.getServletContext().getAttribute(ServletOAuthClient.class.getName());
        try {
            return oAuthClient.getBearerToken(request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ServerRequest.HttpFailure failure) {
            throw new RuntimeException(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getProducts(HttpServletRequest request, String accessToken) throws Failure {
        List list;
        KeycloakSecurityContext session = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        ServletOAuthClient oAuthClient = (ServletOAuthClient)request.getServletContext().getAttribute(ServletOAuthClient.class.getName());
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(UriUtils.getOrigin((String)request.getRequestURL().toString()) + "/database/products");
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new Failure(response.getStatusLine().getStatusCode());
        }
        HttpEntity entity = response.getEntity();
        InputStream is = entity.getContent();
        try {
            list = (List)JsonSerialization.readValue((InputStream)is, TypedList.class);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        is.close();
        return list;
    }
}

