/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.example.OfflineAccessPortalServlet;
import org.keycloak.example.RefreshTokenDAO;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;

public class OfflineAccessPortalServlet
extends HttpServlet {
    public void init() throws ServletException {
        this.getServletContext().setAttribute(HttpClient.class.getName(), (Object)new DefaultHttpClient());
    }

    public void destroy() {
        this.getHttpClient().getConnectionManager().shutdown();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            boolean savedTokenAvailable;
            String refreshTokenInfo;
            if (req.getRequestURI().endsWith("/login")) {
                this.storeToken(req);
                req.getRequestDispatcher("/WEB-INF/pages/loginCallback.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String refreshToken = RefreshTokenDAO.loadToken();
            if (refreshToken == null) {
                refreshTokenInfo = "No token saved in database. Please login first";
                savedTokenAvailable = false;
            } else {
                RefreshToken refreshTokenDecoded = null;
                refreshTokenDecoded = TokenUtil.getRefreshToken((String)refreshToken);
                String exp = refreshTokenDecoded.getExpiration() == 0 ? "NEVER" : Time.toDate((int)refreshTokenDecoded.getExpiration()).toString();
                refreshTokenInfo = String.format("<p>Type: %s</p><p>ID: %s</p><p>Expires: %s</p>", refreshTokenDecoded.getType(), refreshTokenDecoded.getId(), exp);
                savedTokenAvailable = true;
            }
            req.setAttribute("tokenInfo", (Object)refreshTokenInfo);
            req.setAttribute("savedTokenAvailable", (Object)savedTokenAvailable);
            String customers = req.getRequestURI().endsWith("/loadCustomers") ? this.loadCustomers(req, refreshToken) : "";
            req.setAttribute("customers", (Object)customers);
            req.getRequestDispatcher("/WEB-INF/pages/view.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (JWSInputException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void storeToken(HttpServletRequest req) throws IOException, JWSInputException {
        RefreshableKeycloakSecurityContext ctx = (RefreshableKeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName());
        String refreshToken = ctx.getRefreshToken();
        RefreshTokenDAO.saveToken((String)refreshToken);
        RefreshToken refreshTokenDecoded = TokenUtil.getRefreshToken((String)refreshToken);
        Boolean isOfflineToken = refreshTokenDecoded.getType().equals("Offline");
        req.setAttribute("isOfflineToken", (Object)isOfflineToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCustomers(HttpServletRequest req, String refreshToken) throws ServletException, IOException {
        AccessTokenResponse response;
        String accessToken = null;
        try {
            KeycloakDeployment deployment = this.getDeployment(req);
            response = ServerRequest.invokeRefresh((KeycloakDeployment)deployment, (String)refreshToken);
            accessToken = response.getToken();
        }
        catch (ServerRequest.HttpFailure failure) {
            return "Failed to refresh token. Status from auth-server request: " + failure.getStatus() + ", Error: " + failure.getError();
        }
        HttpGet get = new HttpGet(UriUtils.getOrigin((String)req.getRequestURL().toString()) + "/database/customers");
        get.addHeader("Authorization", "Bearer " + accessToken);
        response = this.getHttpClient().execute((HttpUriRequest)get);
        try (InputStream is = response.getEntity().getContent();){
            if (response.getStatusLine().getStatusCode() != 200) {
                String string = "Error when loading customer. Status: " + response.getStatusLine().getStatusCode() + ", error: " + StreamUtil.readString((InputStream)is);
                return string;
            }
            List list = (List)JsonSerialization.readValue((InputStream)is, TypedList.class);
            StringBuilder result = new StringBuilder();
            for (String customer : list) {
                result.append(customer + "<br />");
            }
            String string = result.toString();
            return string;
        }
    }

    private KeycloakDeployment getDeployment(HttpServletRequest servletRequest) throws ServletException {
        HttpFacade facade = this.getFacade(servletRequest);
        AdapterDeploymentContext deploymentContext = (AdapterDeploymentContext)this.getServletContext().getAttribute(AdapterDeploymentContext.class.getName());
        if (deploymentContext == null) {
            throw new ServletException("AdapterDeploymentContext not set");
        }
        return deploymentContext.resolveDeployment(facade);
    }

    private HttpFacade getFacade(HttpServletRequest servletRequest) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private HttpClient getHttpClient() {
        return (HttpClient)this.getServletContext().getAttribute(HttpClient.class.getName());
    }
}

