/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.common.util.UriUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;

public class ProductServiceAccountServlet
extends HttpServlet {
    public static final String ERROR = "error";
    public static final String TOKEN = "token";
    public static final String TOKEN_PARSED = "idTokenParsed";
    public static final String REFRESH_TOKEN = "refreshToken";
    public static final String PRODUCTS = "products";

    public static String getLoginUrl(HttpServletRequest request) {
        return "/service-account-portal/app/login";
    }

    public static String getLogoutUrl(HttpServletRequest request) {
        return "/service-account-portal/app/logout";
    }

    public void init() throws ServletException {
        String adapterConfigLocation = "/WEB-INF/keycloak.json";
        InputStream config = this.getServletContext().getResourceAsStream(adapterConfigLocation);
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)config);
        this.getServletContext().setAttribute(KeycloakDeployment.class.getName(), (Object)deployment);
        DefaultHttpClient client = new DefaultHttpClient();
        this.getServletContext().setAttribute(HttpClient.class.getName(), (Object)client);
    }

    public void destroy() {
        this.getHttpClient().getConnectionManager().shutdown();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqUri = req.getRequestURI();
        if (reqUri.endsWith("/login")) {
            this.serviceAccountLogin(req);
        } else if (reqUri.endsWith("/logout")) {
            this.logout(req);
        }
        if (req.getAttribute(ERROR) == null) {
            this.loadProducts(req);
        }
        req.getRequestDispatcher("/WEB-INF/page.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void serviceAccountLogin(HttpServletRequest req) {
        KeycloakDeployment deployment = this.getKeycloakDeployment();
        HttpClient client = this.getHttpClient();
        try {
            HttpPost post = new HttpPost(deployment.getTokenUrl());
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("grant_type", "client_credentials"));
            HashMap reqHeaders = new HashMap();
            HashMap reqParams = new HashMap();
            ClientCredentialsProviderUtils.setClientCredentials((KeycloakDeployment)deployment, reqHeaders, reqParams);
            for (Map.Entry header : reqHeaders.entrySet()) {
                post.setHeader((String)header.getKey(), (String)header.getValue());
            }
            for (Map.Entry param : reqParams.entrySet()) {
                formparams.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
            }
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
            post.setEntity((HttpEntity)form);
            HttpResponse response = client.execute((HttpUriRequest)post);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (status != 200) {
                String json = this.getContent(entity);
                String error = "Service account login failed. Bad status: " + status + " response: " + json;
                req.setAttribute(ERROR, (Object)error);
            } else if (entity == null) {
                req.setAttribute(ERROR, (Object)"No entity");
            } else {
                String json = this.getContent(entity);
                AccessTokenResponse tokenResp = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                this.setTokens(req, deployment, tokenResp);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            req.setAttribute(ERROR, (Object)("Service account login failed. IOException occured. See server.log for details. Message is: " + ioe.getMessage()));
        }
        catch (VerificationException vfe) {
            req.setAttribute(ERROR, (Object)("Service account login failed. Failed to verify token Message is: " + vfe.getMessage()));
        }
    }

    private void setTokens(HttpServletRequest req, KeycloakDeployment deployment, AccessTokenResponse tokenResponse) throws IOException, VerificationException {
        String token = tokenResponse.getToken();
        String refreshToken = tokenResponse.getRefreshToken();
        AdapterTokenVerifier.VerifiedTokens parsedTokens = AdapterTokenVerifier.verifyTokens((String)token, (String)tokenResponse.getIdToken(), (KeycloakDeployment)deployment);
        AccessToken tokenParsed = parsedTokens.getAccessToken();
        req.getSession().setAttribute(TOKEN, (Object)token);
        req.getSession().setAttribute(REFRESH_TOKEN, (Object)refreshToken);
        req.getSession().setAttribute(TOKEN_PARSED, (Object)tokenParsed);
    }

    private void loadProducts(HttpServletRequest req) {
        HttpClient client = this.getHttpClient();
        String token = (String)req.getSession().getAttribute(TOKEN);
        String requestOrigin = UriUtils.getOrigin((String)req.getRequestURL().toString());
        HttpGet get = new HttpGet(requestOrigin + "/database/products");
        if (token != null) {
            get.addHeader("Authorization", "Bearer " + token);
        }
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                String json = this.getContent(entity);
                String error = "Failed retrieve products. Status: " + status;
                req.setAttribute(ERROR, (Object)error);
            } else if (entity == null) {
                req.setAttribute(ERROR, (Object)"No entity");
            } else {
                String products = this.getContent(entity);
                req.setAttribute(PRODUCTS, (Object)products);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            req.setAttribute(ERROR, (Object)("Failed retrieve products. IOException occured. See server.log for details. Message is: " + ioe.getMessage()));
        }
    }

    private void logout(HttpServletRequest req) {
        KeycloakDeployment deployment = this.getKeycloakDeployment();
        String refreshToken = (String)req.getSession().getAttribute(REFRESH_TOKEN);
        if (refreshToken == null) {
            req.setAttribute(ERROR, (Object)"No refresh token available. Please login first");
        } else {
            try {
                ServerRequest.invokeLogout((KeycloakDeployment)deployment, (String)refreshToken);
                req.getSession().removeAttribute(TOKEN);
                req.getSession().removeAttribute(REFRESH_TOKEN);
                req.getSession().removeAttribute(TOKEN_PARSED);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                req.setAttribute(ERROR, (Object)("Failed refresh token. See server.log for details. Message is: " + ioe.getMessage()));
            }
            catch (ServerRequest.HttpFailure hfe) {
                hfe.printStackTrace();
                req.setAttribute(ERROR, (Object)("Failed refresh token. See server.log for details. Status was: " + hfe.getStatus() + ", Error is: " + hfe.getError()));
            }
        }
    }

    private String getContent(HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        return StreamUtil.readString((InputStream)is);
    }

    private KeycloakDeployment getKeycloakDeployment() {
        return (KeycloakDeployment)this.getServletContext().getAttribute(KeycloakDeployment.class.getName());
    }

    private HttpClient getHttpClient() {
        return (HttpClient)this.getServletContext().getAttribute(HttpClient.class.getName());
    }
}

