/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.kerberos;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSCredential;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.common.util.KerberosSerializationUtils;
import org.keycloak.example.kerberos.GSSCredentialsClient;
import org.keycloak.representations.AccessToken;

/*
 * Exception performing whole class analysis ignored.
 */
public class GSSCredentialsClient {
    public static LDAPUser getUserFromLDAP(HttpServletRequest req) throws Exception {
        KeycloakPrincipal keycloakPrincipal = (KeycloakPrincipal)req.getUserPrincipal();
        AccessToken accessToken = keycloakPrincipal.getKeycloakSecurityContext().getToken();
        String username = accessToken.getPreferredUsername();
        String serializedGssCredential = (String)accessToken.getOtherClaims().get("gss_delegation_credential");
        GSSCredential deserializedGssCredential = KerberosSerializationUtils.deserializeCredential((String)serializedGssCredential);
        try {
            GSSCredentialsClient.invokeLdap(null, (String)username);
            throw new RuntimeException("Not expected to authenticate to LDAP without credential");
        }
        catch (NamingException nse) {
            System.out.println("GSSCredentialsClient: Expected exception: " + nse.getMessage());
            return GSSCredentialsClient.invokeLdap((GSSCredential)deserializedGssCredential, (String)username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LDAPUser invokeLdap(GSSCredential gssCredential, String username) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:10389");
        if (gssCredential != null) {
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.credentials", gssCredential);
        }
        try (InitialDirContext ctx = new InitialDirContext(env);){
            Attributes attrs = ctx.getAttributes("uid=" + username + ",ou=People,dc=keycloak,dc=org");
            String uid = username;
            String cn = (String)attrs.get("cn").get();
            String sn = (String)attrs.get("sn").get();
            LDAPUser lDAPUser = new LDAPUser(uid, cn, sn);
            return lDAPUser;
        }
    }
}

