/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.federation.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.Config;
import org.keycloak.examples.federation.properties.BasePropertiesFederationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class BasePropertiesFederationFactory
implements UserFederationProviderFactory {
    static final Set<String> configOptions = new HashSet<String>();
    protected ConcurrentHashMap<String, Properties> files = new ConcurrentHashMap();

    public UserFederationProvider getInstance(KeycloakSession session, UserFederationProviderModel model) {
        String path = (String)model.getConfig().get("path");
        if (path == null) {
            throw new IllegalStateException("Path attribute not configured for provider");
        }
        Properties props = this.files.get(path);
        if (props != null) {
            return this.createProvider(session, model, props);
        }
        props = new Properties();
        InputStream is = this.getPropertiesFileStream(path);
        try {
            props.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.files.put(path, props);
        return this.createProvider(session, model, props);
    }

    protected abstract InputStream getPropertiesFileStream(String var1);

    protected abstract BasePropertiesFederationProvider createProvider(KeycloakSession var1, UserFederationProviderModel var2, Properties var3);

    public Set<String> getConfigurationOptions() {
        return configOptions;
    }

    public UserFederationProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public UserFederationSyncResult syncAllUsers(KeycloakSessionFactory sessionFactory, final String realmId, final UserFederationProviderModel model) {
        final UserFederationSyncResult syncResult = new UserFederationSyncResult();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel realm = session.realms().getRealm(realmId);
                BasePropertiesFederationProvider federationProvider = (BasePropertiesFederationProvider)BasePropertiesFederationFactory.this.getInstance(session, model);
                Set<String> allUsernames = federationProvider.getProperties().stringPropertyNames();
                UserProvider localProvider = session.userStorage();
                for (String username : allUsernames) {
                    UserModel imported;
                    UserModel localUser = localProvider.getUserByUsername(username, realm);
                    if (localUser != null || (imported = federationProvider.getUserByUsername(realm, username)) == null) continue;
                    syncResult.increaseAdded();
                }
            }
        });
        return syncResult;
    }

    public UserFederationSyncResult syncChangedUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model, Date lastSync) {
        return this.syncAllUsers(sessionFactory, realmId, model);
    }

    static {
        configOptions.add("path");
    }
}

