/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.federation.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;

public abstract class BasePropertiesFederationProvider
implements UserFederationProvider {
    protected static final Set<String> supportedCredentialTypes = new HashSet<String>();
    protected KeycloakSession session;
    protected Properties properties;
    protected UserFederationProviderModel model;

    public BasePropertiesFederationProvider(KeycloakSession session, UserFederationProviderModel model, Properties properties) {
        this.session = session;
        this.model = model;
        this.properties = properties;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public UserFederationProviderModel getModel() {
        return this.model;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        String password = this.properties.getProperty(username);
        if (password != null) {
            UserModel userModel = this.session.userStorage().addUser(realm, username);
            userModel.setEnabled(true);
            userModel.setFederationLink(this.model.getId());
            return userModel;
        }
        return null;
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        UserModel user;
        String username = attributes.get("username");
        if (username != null && this.session.userStorage().getUserByUsername(username, realm) == null && (user = this.getUserByUsername(realm, username)) != null) {
            ArrayList<UserModel> list = new ArrayList<UserModel>(1);
            list.add(user);
            return list;
        }
        return Collections.emptyList();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        return this.properties.containsKey(local.getUsername());
    }

    public Set<String> getSupportedCredentialTypes(UserModel user) {
        return supportedCredentialTypes;
    }

    public Set<String> getSupportedCredentialTypes() {
        return supportedCredentialTypes;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        Iterator<UserCredentialModel> iterator = input.iterator();
        if (iterator.hasNext()) {
            UserCredentialModel cred = iterator.next();
            if (cred.getType().equals("password")) {
                String password = this.properties.getProperty(user.getUsername());
                if (password == null) {
                    return false;
                }
                return password.equals(cred.getValue());
            }
            return false;
        }
        return false;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        int n = 0;
        UserCredentialModel[] userCredentialModelArray = input;
        int n2 = userCredentialModelArray.length;
        if (n < n2) {
            UserCredentialModel cred = userCredentialModelArray[n];
            if (cred.getType().equals("password")) {
                String password = this.properties.getProperty(user.getUsername());
                if (password == null) {
                    return false;
                }
                return password.equals(cred.getValue());
            }
            return false;
        }
        return true;
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    static {
        supportedCredentialTypes.add("password");
    }
}

