/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.federation.properties;

import java.io.InputStream;
import java.util.Properties;
import org.keycloak.examples.federation.properties.BasePropertiesFederationFactory;
import org.keycloak.examples.federation.properties.BasePropertiesFederationProvider;
import org.keycloak.examples.federation.properties.ClasspathPropertiesFederationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserFederationProviderModel;

public class ClasspathPropertiesFederationFactory
extends BasePropertiesFederationFactory {
    public static final String PROVIDER_NAME = "classpath-properties";

    @Override
    protected BasePropertiesFederationProvider createProvider(KeycloakSession session, UserFederationProviderModel model, Properties props) {
        return new ClasspathPropertiesFederationProvider(session, model, props);
    }

    @Override
    protected InputStream getPropertiesFileStream(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalStateException("Path not found for properties file");
        }
        return is;
    }

    public String getId() {
        return PROVIDER_NAME;
    }
}

