/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.federation.properties;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.keycloak.examples.federation.properties.BasePropertiesFederationProvider;
import org.keycloak.examples.federation.properties.WritableUserModelProxy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;

public class FilePropertiesFederationProvider
extends BasePropertiesFederationProvider {
    public FilePropertiesFederationProvider(KeycloakSession session, Properties properties, UserFederationProviderModel model) {
        super(session, model, properties);
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        if (this.isValid(realm, local)) {
            return new WritableUserModelProxy(local, this);
        }
        return null;
    }

    public boolean synchronizeRegistrations() {
        return true;
    }

    public void save() {
        String path = (String)this.getModel().getConfig().get("path");
        try {
            FileOutputStream fos = new FileOutputStream(path);
            this.properties.store(fos, "");
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserModel register(RealmModel realm, UserModel user) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.setProperty(user.getUsername(), "");
            this.save();
        }
        return this.validateAndProxy(realm, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(RealmModel realm, UserModel user) {
        Properties properties = this.properties;
        synchronized (properties) {
            if (this.properties.remove(user.getUsername()) == null) {
                return false;
            }
            this.save();
            return true;
        }
    }
}

