/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.federation.properties;

import java.util.Properties;
import org.keycloak.examples.federation.properties.FilePropertiesFederationProvider;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class WritableUserModelProxy
extends UserModelDelegate {
    protected FilePropertiesFederationProvider provider;

    public WritableUserModelProxy(UserModel delegate, FilePropertiesFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsername(String username) {
        Properties properties;
        if (this.delegate.getUsername().equals(username)) {
            return;
        }
        this.delegate.setUsername(username);
        Properties properties2 = properties = this.provider.getProperties();
        synchronized (properties2) {
            if (properties.containsKey(username)) {
                throw new IllegalStateException("Can't change username to existing user");
            }
            String password = (String)properties.remove(username);
            if (password == null) {
                throw new IllegalStateException("User doesn't exist");
            }
            properties.setProperty(username, password);
            this.provider.save();
        }
    }

    public void updateCredentialDirectly(UserCredentialValueModel cred) {
        if (cred.getType().equals("password")) {
            throw new IllegalStateException("Shouldn't be using this method");
        }
        super.updateCredentialDirectly(cred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            Properties properties = this.provider.getProperties();
            synchronized (properties) {
                if (!this.provider.getProperties().containsKey(this.delegate.getUsername())) {
                    throw new IllegalStateException("no user of that in properties file");
                }
                this.provider.getProperties().setProperty(this.delegate.getUsername(), cred.getValue());
                this.provider.save();
            }
        } else {
            super.updateCredential(cred);
        }
    }
}

