/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.admin.client.resource.AttackDetectionResource;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.admin.client.resource.ClientPoliciesPoliciesResource;
import org.keycloak.admin.client.resource.ClientPoliciesProfilesResource;
import org.keycloak.admin.client.resource.ClientRegistrationPolicyResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.admin.client.resource.KeyResource;
import org.keycloak.admin.client.resource.RealmLocalizationResource;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserStorageProviderResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;

public interface RealmResource {
    @GET
    @Produces(value={"application/json"})
    public RealmRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(RealmRepresentation var1);

    @Path(value="clients")
    public ClientsResource clients();

    @Path(value="client-scopes")
    public ClientScopesResource clientScopes();

    @GET
    @Produces(value={"application/json"})
    @Path(value="default-default-client-scopes")
    public List<ClientScopeRepresentation> getDefaultDefaultClientScopes();

    @PUT
    @Path(value="default-default-client-scopes/{clientScopeId}")
    public void addDefaultDefaultClientScope(@PathParam(value="clientScopeId") String var1);

    @DELETE
    @Path(value="default-default-client-scopes/{clientScopeId}")
    public void removeDefaultDefaultClientScope(@PathParam(value="clientScopeId") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="default-optional-client-scopes")
    public List<ClientScopeRepresentation> getDefaultOptionalClientScopes();

    @PUT
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    public void addDefaultOptionalClientScope(@PathParam(value="clientScopeId") String var1);

    @DELETE
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    public void removeDefaultOptionalClientScope(@PathParam(value="clientScopeId") String var1);

    @Path(value="client-description-converter")
    @POST
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @Produces(value={"application/json"})
    public ClientRepresentation convertClientDescription(String var1);

    @Path(value="users")
    public UsersResource users();

    @Path(value="roles")
    public RolesResource roles();

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById();

    @Path(value="groups")
    public GroupsResource groups();

    @DELETE
    @Path(value="events")
    public void clearEvents();

    @GET
    @Path(value="events")
    @Produces(value={"application/json"})
    public List<EventRepresentation> getEvents();

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<EventRepresentation> getEvents(@QueryParam(value="type") List<String> var1, @QueryParam(value="client") String var2, @QueryParam(value="user") String var3, @QueryParam(value="dateFrom") String var4, @QueryParam(value="dateTo") String var5, @QueryParam(value="ipAddress") String var6, @QueryParam(value="first") Integer var7, @QueryParam(value="max") Integer var8);

    @DELETE
    @Path(value="admin-events")
    public void clearAdminEvents();

    @GET
    @Path(value="admin-events")
    @Produces(value={"application/json"})
    public List<AdminEventRepresentation> getAdminEvents();

    @GET
    @Path(value="admin-events")
    @Produces(value={"application/json"})
    public List<AdminEventRepresentation> getAdminEvents(@QueryParam(value="operationTypes") List<String> var1, @QueryParam(value="authRealm") String var2, @QueryParam(value="authClient") String var3, @QueryParam(value="authUser") String var4, @QueryParam(value="authIpAddress") String var5, @QueryParam(value="resourcePath") String var6, @QueryParam(value="dateFrom") String var7, @QueryParam(value="dateTo") String var8, @QueryParam(value="first") Integer var9, @QueryParam(value="max") Integer var10);

    @GET
    @Path(value="events/config")
    @Produces(value={"application/json"})
    public RealmEventsConfigRepresentation getRealmEventsConfig();

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation var1);

    @GET
    @Path(value="group-by-path/{path: .*}")
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroupByPath(@PathParam(value="path") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="default-groups")
    public List<GroupRepresentation> getDefaultGroups();

    @PUT
    @Path(value="default-groups/{groupId}")
    public void addDefaultGroup(@PathParam(value="groupId") String var1);

    @DELETE
    @Path(value="default-groups/{groupId}")
    public void removeDefaultGroup(@PathParam(value="groupId") String var1);

    @Path(value="identity-provider")
    public IdentityProvidersResource identityProviders();

    @DELETE
    public void remove();

    @Path(value="client-session-stats")
    @GET
    public List<Map<String, String>> getClientSessionStats();

    @Path(value="clients-initial-access")
    public ClientInitialAccessResource clientInitialAccess();

    @Path(value="client-registration-policy")
    public ClientRegistrationPolicyResource clientRegistrationPolicy();

    @Path(value="partialImport")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response partialImport(PartialImportRepresentation var1);

    @Path(value="partial-export")
    @POST
    @Produces(value={"application/json"})
    public RealmRepresentation partialExport(@QueryParam(value="exportGroupsAndRoles") Boolean var1, @QueryParam(value="exportClients") Boolean var2);

    @Path(value="authentication")
    @Consumes(value={"application/json"})
    public AuthenticationManagementResource flows();

    @Path(value="attack-detection")
    public AttackDetectionResource attackDetection();

    @Path(value="testLDAPConnection")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @NoCache
    @Deprecated
    public Response testLDAPConnection(@FormParam(value="action") String var1, @FormParam(value="connectionUrl") String var2, @FormParam(value="bindDn") String var3, @FormParam(value="bindCredential") String var4, @FormParam(value="useTruststoreSpi") String var5, @FormParam(value="connectionTimeout") String var6);

    @Path(value="testLDAPConnection")
    @POST
    @Consumes(value={"application/json"})
    @NoCache
    public Response testLDAPConnection(TestLdapConnectionRepresentation var1);

    @POST
    @Path(value="ldap-server-capabilities")
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<LDAPCapabilityRepresentation> ldapServerCapabilities(TestLdapConnectionRepresentation var1);

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Deprecated
    public Response testSMTPConnection(@FormParam(value="config") String var1);

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response testSMTPConnection(Map<String, String> var1);

    @Path(value="clear-realm-cache")
    @POST
    public void clearRealmCache();

    @Path(value="clear-user-cache")
    @POST
    public void clearUserCache();

    @Path(value="clear-keys-cache")
    @POST
    public void clearKeysCache();

    @Path(value="push-revocation")
    @POST
    @Produces(value={"application/json"})
    public GlobalRequestResult pushRevocation();

    @Path(value="logout-all")
    @POST
    @Produces(value={"application/json"})
    public GlobalRequestResult logoutAll();

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String var1);

    @Path(value="components")
    public ComponentsResource components();

    @Path(value="user-storage")
    public UserStorageProviderResource userStorage();

    @Path(value="keys")
    public KeyResource keys();

    @Path(value="localization")
    public RealmLocalizationResource localization();

    @Path(value="client-policies/policies")
    public ClientPoliciesPoliciesResource clientPoliciesPoliciesResource();

    @Path(value="client-policies/profiles")
    public ClientPoliciesProfilesResource clientPoliciesProfilesResource();
}

