/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import java.net.URI;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.ServerInfoResource;
import org.keycloak.admin.client.token.TokenManager;

public class Keycloak
implements AutoCloseable {
    private final Config config;
    private final TokenManager tokenManager;
    private final String authToken;
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    Keycloak(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, String grantType, ResteasyClient resteasyClient, String authtoken) {
        this.config = new Config(serverUrl, realm, username, password, clientId, clientSecret, grantType);
        this.client = resteasyClient != null ? resteasyClient : Keycloak.newRestEasyClient(null, null, false);
        this.authToken = authtoken;
        this.tokenManager = authtoken == null ? new TokenManager(this.config, this.client) : null;
        this.target = this.client.target(this.config.getServerUrl());
        this.target.register((Object)this.newAuthFilter());
    }

    private BearerAuthFilter newAuthFilter() {
        return this.authToken != null ? new BearerAuthFilter(this.authToken) : new BearerAuthFilter(this.tokenManager);
    }

    private static ResteasyClient newRestEasyClient(ResteasyJackson2Provider customJacksonProvider, SSLContext sslContext, boolean disableTrustManager) {
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().sslContext(sslContext).connectionPoolSize(10);
        if (disableTrustManager) {
            clientBuilder.disableTrustManager().hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY);
        }
        if (customJacksonProvider != null) {
            clientBuilder.register((Object)customJacksonProvider, 100);
        }
        return clientBuilder.build();
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, ResteasyJackson2Provider customJacksonProvider, boolean disableTrustManager, String authToken) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", Keycloak.newRestEasyClient(customJacksonProvider, sslContext, disableTrustManager), authToken);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, null, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, sslContext, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, ResteasyJackson2Provider customJacksonProvider) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, sslContext, customJacksonProvider, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, null, null, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, SSLContext sslContext) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, null, sslContext, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authToken) {
        return Keycloak.getInstance(serverUrl, realm, null, null, clientId, null, null, null, false, authToken);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authToken, SSLContext sllSslContext) {
        return Keycloak.getInstance(serverUrl, realm, null, null, clientId, null, sllSslContext, null, false, authToken);
    }

    public RealmsResource realms() {
        return (RealmsResource)this.target.proxy(RealmsResource.class);
    }

    public RealmResource realm(String realmName) {
        return this.realms().realm(realmName);
    }

    public ServerInfoResource serverInfo() {
        return (ServerInfoResource)this.target.proxy(ServerInfoResource.class);
    }

    public TokenManager tokenManager() {
        return this.tokenManager;
    }

    public <T> T proxy(Class<T> proxyClass, URI absoluteURI) {
        return (T)this.client.target(absoluteURI).register((Object)this.newAuthFilter()).proxy(proxyClass);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }
}

