/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;

public class CorsPreflightChecker {
    private static final Logger log = Logger.getLogger(CorsPreflightChecker.class);
    protected KeycloakDeployment deployment;

    public CorsPreflightChecker(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public boolean checkCorsPreflight(Request request, Response response) {
        String allowHeaders;
        log.debugv("checkCorsPreflight {0}", (Object)request.getRequestURI());
        if (!request.getMethod().equalsIgnoreCase("OPTIONS")) {
            log.debug((Object)"checkCorsPreflight: not options ");
            return false;
        }
        if (request.getHeader("Origin") == null) {
            log.debug((Object)"checkCorsPreflight: no origin header");
            return false;
        }
        log.debug((Object)"Preflight request returning");
        response.setStatus(200);
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        String requestMethods = request.getHeader("Access-Control-Request-Method");
        if (requestMethods != null) {
            if (this.deployment.getCorsAllowedMethods() != null) {
                requestMethods = this.deployment.getCorsAllowedMethods();
            }
            response.setHeader("Access-Control-Allow-Methods", requestMethods);
        }
        if ((allowHeaders = request.getHeader("Access-Control-Request-Headers")) != null) {
            if (this.deployment.getCorsAllowedHeaders() != null) {
                allowHeaders = this.deployment.getCorsAllowedHeaders();
            }
            response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        }
        if (this.deployment.getCorsMaxAge() > -1) {
            response.setHeader("Access-Control-Max-Age", Integer.toString(this.deployment.getCorsMaxAge()));
        }
        return true;
    }
}

