/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.as7;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.keycloak.subsystem.as7.CredentialDefinition;
import org.keycloak.subsystem.as7.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.as7.KeycloakSubsystemParser;
import org.keycloak.subsystem.as7.RealmDefinition;
import org.keycloak.subsystem.as7.SecureDeploymentDefinition;
import org.keycloak.subsystem.as7.logging.KeycloakLogger;

public class KeycloakExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "keycloak";
    public static final String NAMESPACE_1_1 = "urn:jboss:domain:keycloak:1.1";
    public static final String NAMESPACE_1_2 = "urn:jboss:domain:keycloak:1.2";
    public static final String CURRENT_NAMESPACE = "urn:jboss:domain:keycloak:1.2";
    private static final KeycloakSubsystemParser PARSER = new KeycloakSubsystemParser();
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"keycloak");
    private static final String RESOURCE_NAME = KeycloakExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MGMT_API_VERSION_MAJOR = 1;
    private static final int MGMT_API_VERSION_MINOR = 1;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"keycloak");
    private static final ResourceDefinition KEYCLOAK_SUBSYSTEM_RESOURCE = new KeycloakSubsystemDefinition();
    static final RealmDefinition REALM_DEFINITION = new RealmDefinition();
    static final SecureDeploymentDefinition SECURE_DEPLOYMENT_DEFINITION = new SecureDeploymentDefinition();
    static final CredentialDefinition CREDENTIAL_DEFINITION = new CredentialDefinition();

    public static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, KeycloakExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_1, (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:keycloak:1.2", (XMLElementReader)PARSER);
    }

    public void initialize(ExtensionContext context) {
        KeycloakLogger.ROOT_LOGGER.debug("Activating Keycloak Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(KEYCLOAK_SUBSYSTEM_RESOURCE);
        registration.registerSubModel((ResourceDefinition)REALM_DEFINITION);
        ManagementResourceRegistration secureDeploymentRegistration = registration.registerSubModel((ResourceDefinition)SECURE_DEPLOYMENT_DEFINITION);
        secureDeploymentRegistration.registerSubModel((ResourceDefinition)CREDENTIAL_DEFINITION);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }
}

