/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.email;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.AuditListenerFactory;
import org.keycloak.audit.EventType;
import org.keycloak.audit.email.EmailAuditListener;
import org.keycloak.email.EmailProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderSession;

public class EmailAuditListenerFactory
implements AuditListenerFactory {
    private static final Set<EventType> SUPPORTED_EVENTS = new HashSet<EventType>();
    private Set<EventType> includedEvents = new HashSet<EventType>();

    public AuditListener create(ProviderSession providerSession) {
        KeycloakSession keycloakSession = (KeycloakSession)providerSession.getProvider(KeycloakSession.class);
        EmailProvider emailProvider = (EmailProvider)providerSession.getProvider(EmailProvider.class);
        return new EmailAuditListener(keycloakSession, emailProvider, this.includedEvents);
    }

    public void init(Config.Scope config) {
        String[] include = config.getArray("include-events");
        if (include != null) {
            for (String i : include) {
                this.includedEvents.add(EventType.valueOf((String)i.toUpperCase()));
            }
        } else {
            this.includedEvents.addAll(SUPPORTED_EVENTS);
        }
        String[] exclude = config.getArray("exclude-events");
        if (exclude != null) {
            for (String e : exclude) {
                this.includedEvents.remove(EventType.valueOf((String)e.toUpperCase()));
            }
        }
    }

    public void close() {
    }

    public String getId() {
        return "email";
    }

    static {
        Collections.addAll(SUPPORTED_EVENTS, EventType.LOGIN_ERROR, EventType.UPDATE_PASSWORD, EventType.REMOVE_TOTP, EventType.UPDATE_TOTP);
    }
}

