/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventQuery;
import org.keycloak.audit.mongo.MongoEventQuery;

public class MongoAuditProvider
implements AuditProvider {
    private DBCollection audit;

    public MongoAuditProvider(DBCollection audit) {
        this.audit = audit;
    }

    public EventQuery createQuery() {
        return new MongoEventQuery(this.audit);
    }

    public void clear() {
        this.audit.remove((DBObject)new BasicDBObject());
    }

    public void clear(String realmId) {
        this.audit.remove((DBObject)new BasicDBObject("realmId", (Object)realmId));
    }

    public void clear(String realmId, long olderThan) {
        BasicDBObject q = new BasicDBObject();
        q.put("realmId", (Object)realmId);
        q.put("time", (Object)new BasicDBObject("$lt", (Object)olderThan));
        this.audit.remove((DBObject)q);
    }

    public void onEvent(Event event) {
        this.audit.insert(new DBObject[]{MongoAuditProvider.convert(event)});
    }

    public void close() {
    }

    static DBObject convert(Event o) {
        BasicDBObject e = new BasicDBObject();
        e.put("time", (Object)o.getTime());
        e.put("event", (Object)o.getEvent());
        e.put("realmId", (Object)o.getRealmId());
        e.put("clientId", (Object)o.getClientId());
        e.put("userId", (Object)o.getUserId());
        e.put("sessionId", (Object)o.getSessionId());
        e.put("ipAddress", (Object)o.getIpAddress());
        e.put("error", (Object)o.getError());
        BasicDBObject details = new BasicDBObject();
        if (o.getDetails() != null) {
            for (Map.Entry entry : o.getDetails().entrySet()) {
                details.put((String)entry.getKey(), entry.getValue());
            }
        }
        e.put("details", (Object)details);
        return e;
    }

    static Event convert(BasicDBObject o) {
        Event e = new Event();
        e.setTime(o.getLong("time"));
        e.setEvent(o.getString("event"));
        e.setRealmId(o.getString("realmId"));
        e.setClientId(o.getString("clientId"));
        e.setUserId(o.getString("userId"));
        e.setSessionId(o.getString("sessionId"));
        e.setIpAddress(o.getString("ipAddress"));
        e.setError(o.getString("error"));
        BasicDBObject d = (BasicDBObject)o.get("details");
        if (d != null) {
            HashMap<String, String> details = new HashMap<String, String>();
            for (Object k : d.keySet()) {
                details.put((String)k, d.getString((String)k));
            }
            e.setDetails(details);
        }
        return e;
    }
}

