/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.mongo;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.AuditProviderFactory;
import org.keycloak.audit.mongo.MongoAuditProvider;
import org.keycloak.provider.ProviderSession;

public class MongoAuditProviderFactory
implements AuditProviderFactory {
    private static final String MONGO_HOST = "keycloak.audit.mongo.host";
    private static final String MONGO_PORT = "keycloak.audit.mongo.port";
    private static final String MONGO_DB_NAME = "keycloak.audit.mongo.db";
    public static final String ID = "mongo";
    private MongoClient client;
    private DB db;

    public AuditProvider create(ProviderSession providerSession) {
        return new MongoAuditProvider(this.db.getCollection("audit"));
    }

    public void init() {
        try {
            this.client = new MongoClient(System.getProperty(MONGO_HOST, "localhost"), Integer.parseInt(System.getProperty(MONGO_PORT, "27017")));
            this.client.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
            this.db = this.client.getDB(System.getProperty(MONGO_DB_NAME, "keycloak-audit"));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.client.close();
    }

    public String getId() {
        return ID;
    }

    public boolean lazyLoad() {
        return true;
    }
}

