/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventQuery;
import org.keycloak.audit.mongo.MongoAuditProvider;

public class MongoEventQuery
implements EventQuery {
    private Integer firstResult;
    private Integer maxResults;
    private DBCollection audit;
    private final BasicDBObject query;

    public MongoEventQuery(DBCollection audit) {
        this.audit = audit;
        this.query = new BasicDBObject();
    }

    public EventQuery event(String ... events) {
        this.query.put("event", (Object)new BasicDBObject("$in", (Object)events));
        return this;
    }

    public EventQuery realm(String realmId) {
        this.query.put("realmId", (Object)realmId);
        return this;
    }

    public EventQuery client(String clientId) {
        this.query.put("clientId", (Object)clientId);
        return this;
    }

    public EventQuery user(String userId) {
        this.query.put("userId", (Object)userId);
        return this;
    }

    public EventQuery ipAddress(String ipAddress) {
        this.query.put("ipAddress", (Object)ipAddress);
        return this;
    }

    public EventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public EventQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Event> getResultList() {
        DBCursor cur = this.audit.find((DBObject)this.query).sort((DBObject)new BasicDBObject("time", (Object)-1));
        if (this.firstResult != null) {
            cur.skip(this.firstResult.intValue());
        }
        if (this.maxResults != null) {
            cur.limit(this.maxResults.intValue());
        }
        LinkedList<Event> events = new LinkedList<Event>();
        while (cur.hasNext()) {
            events.add(MongoAuditProvider.convert((BasicDBObject)cur.next()));
        }
        return events;
    }
}

