/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.authentication.model.AbstractModelAuthenticationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderSession;

public class ExternalModelAuthenticationProvider
extends AbstractModelAuthenticationProvider {
    public ExternalModelAuthenticationProvider(ProviderSession providerSession) {
    }

    public String getName() {
        return "externalModel";
    }

    public List<String> getAvailableOptions() {
        return Arrays.asList("externalRealmId");
    }

    @Override
    public RealmModel getRealm(RealmModel currentRealm, Map<String, String> configuration) throws AuthenticationProviderException {
        String realmId = configuration.get("externalRealmId");
        if (realmId == null) {
            throw new AuthenticationProviderException("Option 'externalRealmId' not specified in configuration");
        }
        KeycloakSession session = (KeycloakSession)ResteasyProviderFactory.getContextData(KeycloakSession.class);
        if (session == null) {
            throw new AuthenticationProviderException("KeycloakSession not available");
        }
        RealmModel realm = session.getRealm(realmId);
        if (realm == null) {
            throw new AuthenticationProviderException("Realm with id '" + realmId + "' doesn't exists");
        }
        return realm;
    }
}

