/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.model;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthProviderStatus;
import org.keycloak.authentication.AuthUser;
import org.keycloak.authentication.AuthenticationProvider;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class AbstractModelAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = Logger.getLogger(AbstractModelAuthenticationProvider.class);

    public AuthUser getUser(RealmModel currentRealm, Map<String, String> config, String username) throws AuthenticationProviderException {
        RealmModel realm = this.getRealm(currentRealm, config);
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((RealmModel)realm, (String)username);
        return user == null ? null : this.createAuthenticatedUserInstance(user);
    }

    public String registerUser(RealmModel currentRealm, Map<String, String> config, String username) throws AuthenticationProviderException {
        RealmModel realm = this.getRealm(currentRealm, config);
        UserModel user = currentRealm.addUser(username);
        user.setEnabled(true);
        return user.getId();
    }

    public AuthProviderStatus validatePassword(RealmModel currentRealm, Map<String, String> config, String username, String password) throws AuthenticationProviderException {
        UserModel user;
        RealmModel realm = this.getRealm(currentRealm, config);
        boolean result = realm.validatePassword(user = KeycloakModelUtils.findUserByNameOrEmail((RealmModel)realm, (String)username), password);
        return result ? AuthProviderStatus.SUCCESS : AuthProviderStatus.INVALID_CREDENTIALS;
    }

    public boolean updateCredential(RealmModel currentRealm, Map<String, String> config, String username, String password) throws AuthenticationProviderException {
        RealmModel realm = this.getRealm(currentRealm, config);
        String error = realm.getPasswordPolicy().validate(password);
        if (error != null) {
            throw new AuthenticationProviderException(error);
        }
        UserModel user = realm.getUser(username);
        if (user == null) {
            logger.warnf("User '%s' doesn't exists. Skip password update", (Object)username);
            return false;
        }
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue(password);
        realm.updateCredential(user, cred);
        return true;
    }

    public void close() {
    }

    protected abstract RealmModel getRealm(RealmModel var1, Map<String, String> var2) throws AuthenticationProviderException;

    protected AuthUser createAuthenticatedUserInstance(UserModel user) {
        return new AuthUser(user.getId(), user.getLoginName(), this.getName()).setName(user.getFirstName(), user.getLastName()).setEmail(user.getEmail());
    }
}

