/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import org.keycloak.authorization.client.util.HttpMethod;

public class HttpMethodAuthenticator<R> {
    private final HttpMethod<R> method;

    public HttpMethodAuthenticator(HttpMethod<R> method) {
        this.method = method;
    }

    public HttpMethod<R> oauth2ClientCredentials() {
        this.method.params.put("grant_type", "client_credentials");
        this.configureClientCredentials();
        return this.method;
    }

    public HttpMethod<R> oauth2ResourceOwnerPassword(String userName, String password) {
        this.method.params.put("grant_type", "password");
        this.method.params.put("username", userName);
        this.method.params.put("password", password);
        this.configureClientCredentials();
        return this.method;
    }

    private void configureClientCredentials() {
        this.method.configuration.getClientAuthenticator().configureClientCredentials(this.method.params, this.method.headers);
    }
}

