/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.camel.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.camel.undertow.UndertowKeycloakEndpoint;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.keycloak.adapters.undertow.SessionManagementBridge;
import org.keycloak.adapters.undertow.UndertowCookieTokenStore;
import org.keycloak.adapters.undertow.UndertowRequestAuthenticator;
import org.keycloak.adapters.undertow.UndertowSessionTokenStore;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.enums.TokenStore;

public class UndertowKeycloakConsumer
extends UndertowConsumer {
    private static final Logger LOG = Logger.getLogger(UndertowKeycloakConsumer.class.getName());
    public static final AttachmentKey<KeycloakPrincipal> KEYCLOAK_PRINCIPAL_KEY = AttachmentKey.create(KeycloakPrincipal.class);
    private static final IdentityManager IDENTITY_MANAGER = new IdentityManager(){

        public Account verify(Account account) {
            return account;
        }

        public Account verify(String id, Credential credential) {
            throw new IllegalStateException("Should never be called in Keycloak flow");
        }

        public Account verify(Credential credential) {
            throw new IllegalStateException("Should never be called in Keycloak flow");
        }
    };
    protected SessionIdMapper idMapper = new InMemorySessionIdMapper();
    protected final NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
    private final UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
    protected final AdapterDeploymentContext deploymentContext;
    protected final SessionManager sessionManager;
    protected final List<String> allowedRoles;
    private final int confidentialPort;
    private final Pattern skipPattern;

    public UndertowKeycloakConsumer(UndertowKeycloakEndpoint endpoint, Processor processor, AdapterDeploymentContext deploymentContext, Pattern skipPattern, List<String> allowedRoles, int confidentialPort) {
        super((UndertowEndpoint)endpoint, processor);
        this.sessionManager = new InMemorySessionManager(endpoint.getEndpointUri());
        this.deploymentContext = deploymentContext;
        this.skipPattern = skipPattern;
        this.confidentialPort = confidentialPort;
        this.allowedRoles = allowedRoles == null ? Collections.emptyList() : allowedRoles;
    }

    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        if (this.shouldSkip(httpExchange.getRequestPath())) {
            super.handleRequest(httpExchange);
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        OIDCUndertowHttpFacade facade = new OIDCUndertowHttpFacade(httpExchange);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            httpExchange.setStatusCode(403);
            LOG.fine("deployment not configured");
            return;
        }
        LOG.fine("executing PreAuthActionsHandler");
        SessionManagementBridge bridge = new SessionManagementBridge(this.userSessionManagement, this.sessionManager);
        PreAuthActionsHandler preAuth = new PreAuthActionsHandler((UserSessionManagement)bridge, this.deploymentContext, (HttpFacade)facade);
        if (preAuth.handleRequest()) {
            return;
        }
        SecurityContext securityContext = httpExchange.getSecurityContext();
        if (securityContext == null) {
            securityContext = new SecurityContextImpl(httpExchange, IDENTITY_MANAGER);
        }
        AdapterTokenStore tokenStore = this.getTokenStore(httpExchange, (HttpFacade)facade, deployment, securityContext);
        tokenStore.checkCurrentToken();
        LOG.fine("executing AuthenticatedActionsHandler");
        UndertowRequestAuthenticator authenticator = new UndertowRequestAuthenticator((HttpFacade)facade, deployment, this.confidentialPort, securityContext, httpExchange, tokenStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            LOG.fine("AUTHENTICATED");
            if (httpExchange.isResponseComplete()) {
                return;
            }
            AuthenticatedActionsHandler actions = new AuthenticatedActionsHandler(deployment, (OIDCHttpFacade)facade);
            if (actions.handledRequest()) {
                return;
            }
            Account authenticatedAccount = securityContext.getAuthenticatedAccount();
            if (authenticatedAccount instanceof KeycloakUndertowAccount) {
                KeycloakUndertowAccount kua = (KeycloakUndertowAccount)authenticatedAccount;
                httpExchange.putAttachment(KEYCLOAK_PRINCIPAL_KEY, (Object)((KeycloakPrincipal)kua.getPrincipal()));
            }
            Set roles = Optional.ofNullable(authenticatedAccount.getRoles()).orElse(Collections.EMPTY_SET);
            LOG.log(Level.FINE, "Allowed roles: {0}, current roles: {1}", new Object[]{this.allowedRoles, roles});
            if (this.isRoleAllowed(roles, httpExchange)) {
                super.handleRequest(httpExchange);
            } else {
                httpExchange.setStatusCode(403);
            }
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            LOG.fine("challenge");
            challenge.challenge((HttpFacade)facade);
            return;
        }
        httpExchange.setStatusCode(403);
    }

    public boolean isRoleAllowed(Set<String> roles, HttpServerExchange httpExchange) throws Exception {
        for (String role : this.allowedRoles) {
            if (!roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    protected AdapterTokenStore getTokenStore(HttpServerExchange exchange, HttpFacade facade, KeycloakDeployment deployment, SecurityContext securityContext) {
        if (deployment.getTokenStore() == TokenStore.SESSION) {
            return new UndertowSessionTokenStore(exchange, deployment, this.userSessionManagement, securityContext);
        }
        return new UndertowCookieTokenStore(facade, deployment, securityContext);
    }

    private boolean shouldSkip(String requestPath) {
        return this.skipPattern != null && this.skipPattern.matcher(requestPath).matches();
    }
}

