/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.AdapterRSATokenVerifier;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.AuthorizationRequest;
import org.keycloak.authorization.client.representation.AuthorizationResponse;
import org.keycloak.authorization.client.representation.EntitlementRequest;
import org.keycloak.authorization.client.representation.EntitlementResponse;
import org.keycloak.authorization.client.representation.PermissionRequest;
import org.keycloak.authorization.client.representation.PermissionResponse;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public class KeycloakAdapterPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(KeycloakAdapterPolicyEnforcer.class);

    public KeycloakAdapterPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        super(policyEnforcer);
    }

    @Override
    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        AccessToken.Authorization newAuthorization;
        AccessToken original = accessToken;
        if (super.isAuthorized(pathConfig, requiredScopes, accessToken, httpFacade)) {
            return true;
        }
        accessToken = this.requestAuthorizationToken(pathConfig, requiredScopes, httpFacade);
        if (accessToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = original.getAuthorization();
        if (authorization == null) {
            authorization = new AccessToken.Authorization();
            authorization.setPermissions(new ArrayList<Permission>());
        }
        if ((newAuthorization = accessToken.getAuthorization()) != null) {
            authorization.getPermissions().addAll(newAuthorization.getPermissions());
        }
        original.setAuthorization(authorization);
        return super.isAuthorized(pathConfig, requiredScopes, accessToken, httpFacade);
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade facade) {
        this.handleAccessDenied(facade);
        return true;
    }

    @Override
    protected void handleAccessDenied(OIDCHttpFacade facade) {
        String accessDeniedPath = this.getEnforcerConfig().getOnDenyRedirectTo();
        HttpFacade.Response response = facade.getResponse();
        if (accessDeniedPath != null) {
            response.setStatus(302);
            response.setHeader("Location", accessDeniedPath);
        } else {
            response.sendError(403);
        }
    }

    private AccessToken requestAuthorizationToken(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade httpFacade) {
        try {
            String accessToken = httpFacade.getSecurityContext().getTokenString();
            AuthzClient authzClient = this.getAuthzClient();
            KeycloakDeployment deployment = this.getPolicyEnforcer().getDeployment();
            if (this.getEnforcerConfig().getUserManagedAccess() != null) {
                LOGGER.debug("Obtaining authorization for authenticated user.");
                PermissionRequest permissionRequest = new PermissionRequest();
                permissionRequest.setResourceSetId(pathConfig.getId());
                permissionRequest.setScopes(requiredScopes);
                PermissionResponse permissionResponse = authzClient.protection().permission().forResource(permissionRequest);
                AuthorizationRequest authzRequest = new AuthorizationRequest(permissionResponse.getTicket());
                AuthorizationResponse authzResponse = authzClient.authorization(accessToken).authorize(authzRequest);
                if (authzResponse != null) {
                    return AdapterRSATokenVerifier.verifyToken(authzResponse.getRpt(), deployment);
                }
                return null;
            }
            LOGGER.debug("Obtaining entitlements for authenticated user.");
            AccessToken token = httpFacade.getSecurityContext().getToken();
            if (token.getAuthorization() == null) {
                EntitlementResponse authzResponse = authzClient.entitlement(accessToken).getAll(authzClient.getConfiguration().getResource());
                return AdapterRSATokenVerifier.verifyToken(authzResponse.getRpt(), deployment);
            }
            EntitlementRequest request = new EntitlementRequest();
            PermissionRequest permissionRequest = new PermissionRequest();
            permissionRequest.setResourceSetId(pathConfig.getId());
            permissionRequest.setResourceSetName(pathConfig.getName());
            permissionRequest.setScopes(new HashSet<String>(pathConfig.getScopes()));
            LOGGER.debugf("Sending entitlements request: resource_set_id [%s], resource_set_name [%s], scopes [%s].", (Object)permissionRequest.getResourceSetId(), (Object)permissionRequest.getResourceSetName(), (Object)permissionRequest.getScopes());
            request.addPermission(permissionRequest);
            EntitlementResponse authzResponse = authzClient.entitlement(accessToken).get(authzClient.getConfiguration().getResource(), request);
            return AdapterRSATokenVerifier.verifyToken(authzResponse.getRpt(), deployment);
        }
        catch (AuthorizationDeniedException e) {
            LOGGER.debug((Object)"Authorization denied", e);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error during authorization request.", e);
        }
    }
}

