/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authentication;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProvider;

public class ClientCredentialsProviderUtils {
    private static Logger logger = Logger.getLogger(ClientCredentialsProviderUtils.class);

    public static ClientCredentialsProvider bootstrapClientAuthenticator(KeycloakDeployment deployment) {
        String authenticatorId;
        String clientId = deployment.getResourceName();
        Map<String, Object> clientCredentials = deployment.getResourceCredentials();
        if (clientCredentials == null || clientCredentials.isEmpty()) {
            authenticatorId = "secret";
        } else {
            authenticatorId = (String)clientCredentials.get("provider");
            if (authenticatorId == null) {
                if (clientCredentials.size() == 1) {
                    authenticatorId = clientCredentials.keySet().iterator().next();
                } else {
                    throw new RuntimeException("Can't identify clientAuthenticator from the configuration of client '" + clientId + "' . Check your adapter configurations");
                }
            }
        }
        logger.debugf("Using provider '%s' for authentication of client '%s'", (Object)authenticatorId, (Object)clientId);
        HashMap<String, ClientCredentialsProvider> authenticators = new HashMap<String, ClientCredentialsProvider>();
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, ClientCredentialsProviderUtils.class.getClassLoader());
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, Thread.currentThread().getContextClassLoader());
        ClientCredentialsProvider authenticator = (ClientCredentialsProvider)authenticators.get(authenticatorId);
        if (authenticator == null) {
            throw new RuntimeException("Couldn't find ClientCredentialsProvider implementation class with id: " + authenticatorId + ". Loaded authentication providers: " + authenticators.keySet());
        }
        Object config = clientCredentials == null ? null : clientCredentials.get(authenticatorId);
        authenticator.init(deployment, config);
        return authenticator;
    }

    private static void loadAuthenticators(Map<String, ClientCredentialsProvider> authenticators, ClassLoader classLoader) {
        Iterator<ClientCredentialsProvider> iterator = ServiceLoader.load(ClientCredentialsProvider.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                ClientCredentialsProvider authenticator = iterator.next();
                logger.debugf("Loaded clientCredentialsProvider %s", (Object)authenticator.getId());
                authenticators.put(authenticator.getId(), authenticator);
            }
            catch (ServiceConfigurationError e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to load clientCredentialsProvider with classloader: " + classLoader), e);
            }
        }
    }

    public static void setClientCredentials(KeycloakDeployment deployment, Map<String, String> requestHeaders, Map<String, String> formparams) {
        ClientCredentialsProvider authenticator = deployment.getClientAuthenticator();
        authenticator.setClientCredentials(deployment, requestHeaders, formparams);
    }

    public static void setClientCredentials(KeycloakDeployment deployment, HttpPost post, List<NameValuePair> formparams) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        ClientCredentialsProviderUtils.setClientCredentials(deployment, reqHeaders, reqParams);
        for (Map.Entry header : reqHeaders.entrySet()) {
            post.setHeader((String)header.getKey(), (String)header.getValue());
        }
        for (Map.Entry param : reqParams.entrySet()) {
            formparams.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
    }
}

