/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.keycloak.common.Version;

public class Profile {
    private static final Profile CURRENT = new Profile();
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();

    private Profile() {
        try {
            File file;
            Properties props = new Properties();
            String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
            if (jbossServerConfigDir != null && (file = new File(jbossServerConfigDir, "profile.properties")).isFile()) {
                props.load(new FileInputStream(file));
            }
            if (System.getProperties().containsKey("keycloak.profile")) {
                props.setProperty("profile", System.getProperty("keycloak.profile"));
            }
            for (String k : System.getProperties().stringPropertyNames()) {
                if (!k.startsWith("keycloak.profile.feature.")) continue;
                props.put(k.replace("keycloak.profile.feature.", "feature."), System.getProperty(k));
            }
            this.profile = props.containsKey("profile") ? ProfileValue.valueOf(props.getProperty("profile").toUpperCase()) : ProfileValue.valueOf(Version.DEFAULT_PROFILE.toUpperCase());
            this.disabledFeatures.addAll(this.profile.disabled);
            for (String k : props.stringPropertyNames()) {
                if (!k.startsWith("feature.")) continue;
                Feature f = Feature.valueOf(k.replace("feature.", "").toUpperCase());
                if (props.get(k).equals("enabled")) {
                    this.disabledFeatures.remove((Object)f);
                    continue;
                }
                if (!props.get(k).equals("disabled")) continue;
                this.disabledFeatures.add(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName() {
        return Profile.CURRENT.profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.CURRENT.disabledFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return !Profile.CURRENT.disabledFeatures.contains((Object)feature);
    }

    private static enum ProfileValue {
        PRODUCT(Feature.AUTHORIZATION, Feature.SCRIPTS, Feature.DOCKER, Feature.ACCOUNT2, Feature.TOKEN_EXCHANGE),
        PREVIEW(Feature.ACCOUNT2),
        COMMUNITY(Feature.DOCKER, Feature.ACCOUNT2);

        private List<Feature> disabled;

        private ProfileValue() {
            this.disabled = Collections.emptyList();
        }

        private ProfileValue(Feature ... disabled) {
            this.disabled = Arrays.asList(disabled);
        }
    }

    public static enum Feature {
        AUTHORIZATION,
        IMPERSONATION,
        SCRIPTS,
        DOCKER,
        ACCOUNT2,
        TOKEN_EXCHANGE;

    }
}

