/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.extractors;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.annotations.LinkHeaderParam;
import org.jboss.resteasy.annotations.Status;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

public class ResponseObjectEntityExtractorFactory
extends DefaultEntityExtractorFactory {
    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (method.isAnnotationPresent(Status.class)) {
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return new EntityExtractor<Integer>(){

                    @Override
                    public Integer extractEntity(ClientRequestContext context, Object ... args) {
                        return context.getClientResponse().getStatus();
                    }
                };
            }
            if (returnType == Response.Status.class) {
                return ResponseObjectEntityExtractorFactory.createStatusExtractor(false);
            }
        }
        if (method.isAnnotationPresent(Body.class)) {
            return new BodyEntityExtractor(method);
        }
        final HeaderParam headerParam = method.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getClientResponse().getResponseHeaders().getFirst(headerParam.value());
                }
            };
        }
        LinkHeaderParam link = method.getAnnotation(LinkHeaderParam.class);
        if (link != null) {
            return this.processLinkHeader(method, returnType, link);
        }
        if (returnType == ClientRequest.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getRequest();
                }
            };
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return this.createResponseTypeEntityExtractor(method);
        }
        if (returnType == LinkHeader.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getClientResponse().getLinkHeader();
                }
            };
        }
        return null;
    }

    private EntityExtractor processLinkHeader(final Method method, Class<?> returnType, final LinkHeaderParam link) {
        if ("".equals(link.rel()) && "".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.mustSetLinkHeaderRelOrTitle(method.getClass().getName(), method.getName()));
        }
        if (!"".equals(link.rel()) && !"".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.canOnlySetLinkHeaderRelOrTitle(method.getClass().getName(), method.getName()));
        }
        if (returnType == Link.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                }
            };
        }
        if (ResponseObjectEntityExtractorFactory.isInvokerMethod(method)) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    URI uri = ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                    if (uri == null) {
                        return null;
                    }
                    ClientRequest request = context.getRequest();
                    EntityExtractorFactory extractor = context.getExtractorFactory();
                    ResteasyProviderFactory provider = request.getProviderFactory();
                    ClientExecutor executor = request.getExecutor();
                    return ProxyFactory.createClientInvoker(method.getDeclaringClass(), method, uri, executor, provider, extractor).invoke(args);
                }
            };
        }
        if (returnType == String.class) {
            return new EntityExtractor<String>(){

                @Override
                public String extractEntity(ClientRequestContext context, Object ... args) {
                    Link link2 = ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                    return link2 == null ? null : link2.getHref();
                }
            };
        }
        if (returnType == URL.class) {
            return new EntityExtractor<URL>(){

                @Override
                public URL extractEntity(ClientRequestContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURL(method, link, context);
                }
            };
        }
        if (returnType == URI.class) {
            return new EntityExtractor<URI>(){

                @Override
                public URI extractEntity(ClientRequestContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                }
            };
        }
        if (returnType.equals(ClientRequest.class)) {
            return new EntityExtractor<ClientRequest>(){

                @Override
                public ClientRequest extractEntity(ClientRequestContext context, Object ... args) {
                    URI uri = ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                    return uri == null ? null : context.getRequest().createSubsequentRequest(uri);
                }
            };
        }
        return null;
    }

    private static boolean isInvokerMethod(Method method) {
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        return httpMethods != null && httpMethods.size() == 1;
    }

    private Link getLink(LinkHeaderParam link, ClientRequestContext context) {
        LinkHeader linkHeader = context.getClientResponse().getLinkHeader();
        if (!"".equals(link.rel())) {
            return linkHeader.getLinkByRelationship(link.rel());
        }
        return linkHeader.getLinkByTitle(link.title());
    }

    private URI getURI(Method method, Link link) {
        if (link == null) {
            return null;
        }
        try {
            return new URI(link.getHref());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotCreateURI(link.getHref(), method.getClass().getName(), method.getName()), e);
        }
    }

    private URI getURI(Method method, LinkHeaderParam link, ClientRequestContext context) {
        return this.getURI(method, this.getLink(link, context));
    }

    private URL getURL(Method method, LinkHeaderParam link, ClientRequestContext context) {
        URI uri = this.getURI(method, link, context);
        try {
            return uri == null ? null : uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotCreateURI(uri.toASCIIString(), method.getClass().getName(), method.getName()), e);
        }
    }
}

