/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.common.util.Base64;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JsonSerialization;

public class ClientRegistration {
    private String clientRegistrationUrl;
    private HttpClient httpClient;
    private Auth auth;

    public static ClientRegistrationBuilder create() {
        return new ClientRegistrationBuilder();
    }

    private ClientRegistration() {
    }

    public ClientRepresentation create(ClientRepresentation client) throws ClientRegistrationException {
        String content = this.serialize(client);
        InputStream resultStream = this.doPost(content);
        return this.deserialize(resultStream, ClientRepresentation.class);
    }

    public ClientRepresentation get() throws ClientRegistrationException {
        if (this.auth instanceof ClientIdSecretAuth) {
            String clientId = ((ClientIdSecretAuth)this.auth).clientId;
            return this.get(clientId);
        }
        throw new ClientRegistrationException("Requires client authentication");
    }

    public ClientRepresentation get(String clientId) throws ClientRegistrationException {
        InputStream resultStream = this.doGet(clientId);
        return resultStream != null ? this.deserialize(resultStream, ClientRepresentation.class) : null;
    }

    public void update(ClientRepresentation client) throws ClientRegistrationException {
        String content = this.serialize(client);
        this.doPut(content, client.getClientId());
    }

    public void delete() throws ClientRegistrationException {
        if (!(this.auth instanceof ClientIdSecretAuth)) {
            throw new ClientRegistrationException("Requires client authentication");
        }
        String clientId = ((ClientIdSecretAuth)this.auth).clientId;
        this.delete(clientId);
    }

    public void delete(String clientId) throws ClientRegistrationException {
        this.doDelete(clientId);
    }

    public void close() throws ClientRegistrationException {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException e) {
                throw new ClientRegistrationException("Failed to close http client", e);
            }
        }
    }

    private InputStream doPost(String content) throws ClientRegistrationException {
        try {
            HttpPost request = new HttpPost(this.clientRegistrationUrl);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Accept", "application/json");
            request.setEntity((HttpEntity)new StringEntity(content));
            this.auth.addAuth((HttpRequest)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                return responseStream;
            }
            responseStream.close();
            throw new HttpErrorException(response.getStatusLine());
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    private InputStream doGet(String endpoint) throws ClientRegistrationException {
        try {
            HttpGet request = new HttpGet(this.clientRegistrationUrl + "/" + endpoint);
            request.setHeader("Accept", "application/json");
            this.auth.addAuth((HttpRequest)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                return responseStream;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                responseStream.close();
                return null;
            }
            responseStream.close();
            throw new HttpErrorException(response.getStatusLine());
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    private void doPut(String content, String endpoint) throws ClientRegistrationException {
        try {
            HttpPut request = new HttpPut(this.clientRegistrationUrl + "/" + endpoint);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Accept", "application/json");
            request.setEntity((HttpEntity)new StringEntity(content));
            this.auth.addAuth((HttpRequest)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                response.getEntity().getContent().close();
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpErrorException(response.getStatusLine());
            }
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    private void doDelete(String endpoint) throws ClientRegistrationException {
        try {
            HttpDelete request = new HttpDelete(this.clientRegistrationUrl + "/" + endpoint);
            this.auth.addAuth((HttpRequest)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                response.getEntity().getContent().close();
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpErrorException(response.getStatusLine());
            }
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    private String serialize(ClientRepresentation client) throws ClientRegistrationException {
        try {
            return JsonSerialization.writeValueAsString((Object)client);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to write json object", e);
        }
    }

    private <T> T deserialize(InputStream inputStream, Class<T> clazz) throws ClientRegistrationException {
        try {
            return (T)JsonSerialization.readValue((InputStream)inputStream, clazz);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to read json object", e);
        }
    }

    public static class ClientIdSecretAuth
    extends AuthorizationHeaderAuth {
        private String clientId;

        public ClientIdSecretAuth(String clientId, String clientSecret) {
            super("Basic " + Base64.encodeBytes((byte[])(clientId + ":" + clientSecret).getBytes()));
            this.clientId = clientId;
        }
    }

    public static class TokenAuth
    extends AuthorizationHeaderAuth {
        public TokenAuth(String token) {
            super("Bearer " + token);
        }
    }

    public static class AuthorizationHeaderAuth
    implements Auth {
        private String credentials;

        public AuthorizationHeaderAuth(String credentials) {
            this.credentials = credentials;
        }

        @Override
        public void addAuth(HttpRequest httpRequest) {
            httpRequest.setHeader("Authorization", this.credentials);
        }
    }

    public static interface Auth {
        public void addAuth(HttpRequest var1);
    }

    public static class ClientRegistrationBuilder {
        private String realm;
        private String authServerUrl;
        private Auth auth;
        private HttpClient httpClient;

        public ClientRegistrationBuilder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public ClientRegistrationBuilder authServerUrl(String authServerUrl) {
            this.authServerUrl = authServerUrl;
            return this;
        }

        public ClientRegistrationBuilder auth(String token) {
            this.auth = new TokenAuth(token);
            return this;
        }

        public ClientRegistrationBuilder auth(String clientId, String clientSecret) {
            this.auth = new ClientIdSecretAuth(clientId, clientSecret);
            return this;
        }

        public ClientRegistrationBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ClientRegistration build() {
            ClientRegistration clientRegistration = new ClientRegistration();
            clientRegistration.clientRegistrationUrl = this.authServerUrl + "/realms/" + this.realm + "/client-registration/default";
            clientRegistration.httpClient = (HttpClient)(this.httpClient != null ? this.httpClient : HttpClients.createDefault());
            clientRegistration.auth = this.auth;
            return clientRegistration;
        }
    }
}

