/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.client.admin.cli.config.RealmConfigData;
import org.keycloak.util.JsonSerialization;

public class ConfigData {
    private String serverUrl;
    private String realm;
    private String truststore;
    private String trustpass;
    private Map<String, Map<String, RealmConfigData>> endpoints = new HashMap<String, Map<String, RealmConfigData>>();

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTrustpass() {
        return this.trustpass;
    }

    public void setTrustpass(String trustpass) {
        this.trustpass = trustpass;
    }

    public Map<String, Map<String, RealmConfigData>> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, Map<String, RealmConfigData>> endpoints) {
        for (Map.Entry<String, Map<String, RealmConfigData>> entry : endpoints.entrySet()) {
            String endpoint = entry.getKey();
            for (Map.Entry<String, RealmConfigData> sub : entry.getValue().entrySet()) {
                RealmConfigData rdata = sub.getValue();
                rdata.serverUrl(endpoint);
                rdata.realm(sub.getKey());
            }
        }
        this.endpoints = endpoints;
    }

    public RealmConfigData sessionRealmConfigData() {
        if (this.serverUrl == null) {
            throw new RuntimeException("Illegal state - no current endpoint in config data");
        }
        if (this.realm == null) {
            throw new RuntimeException("Illegal state - no current realm in config data");
        }
        return this.ensureRealmConfigData(this.serverUrl, this.realm);
    }

    public RealmConfigData getRealmConfigData(String endpoint, String realm) {
        Map<String, RealmConfigData> realmData = this.endpoints.get(endpoint);
        if (realmData == null) {
            return null;
        }
        return realmData.get(realm);
    }

    public RealmConfigData ensureRealmConfigData(String endpoint, String realm) {
        RealmConfigData result = this.getRealmConfigData(endpoint, realm);
        if (result == null) {
            result = new RealmConfigData();
            result.serverUrl(endpoint);
            result.realm(realm);
            this.setRealmConfigData(result);
        }
        return result;
    }

    public void setRealmConfigData(RealmConfigData data) {
        Map<String, RealmConfigData> realm = this.endpoints.get(data.serverUrl());
        if (realm == null) {
            realm = new HashMap<String, RealmConfigData>();
            this.endpoints.put(data.serverUrl(), realm);
        }
        realm.put(data.realm(), data);
    }

    public void merge(ConfigData source) {
        this.serverUrl = source.serverUrl;
        this.realm = source.realm;
        this.truststore = source.truststore;
        this.trustpass = source.trustpass;
        RealmConfigData current = this.getRealmConfigData(this.serverUrl, this.realm);
        RealmConfigData sourceRealm = source.getRealmConfigData(this.serverUrl, this.realm);
        if (current == null) {
            this.setRealmConfigData(sourceRealm);
        } else {
            current.merge(sourceRealm);
        }
    }

    public ConfigData deepcopy() {
        ConfigData data = new ConfigData();
        data.serverUrl = this.serverUrl;
        data.realm = this.realm;
        data.truststore = this.truststore;
        data.trustpass = this.trustpass;
        data.endpoints = new HashMap<String, Map<String, RealmConfigData>>();
        for (Map.Entry<String, Map<String, RealmConfigData>> item : this.endpoints.entrySet()) {
            HashMap<String, RealmConfigData> nuitems = new HashMap<String, RealmConfigData>();
            Map<String, RealmConfigData> curitems = item.getValue();
            if (curitems == null) continue;
            for (Map.Entry<String, RealmConfigData> ditem : curitems.entrySet()) {
                RealmConfigData nudata = ditem.getValue();
                if (nudata == null) continue;
                nuitems.put(ditem.getKey(), nudata.deepcopy());
            }
            data.endpoints.put(item.getKey(), nuitems);
        }
        return data;
    }

    public String toString() {
        try {
            return JsonSerialization.writeValueAsPrettyString(this);
        }
        catch (IOException e) {
            return super.toString() + " - Error: " + e.toString();
        }
    }
}

