/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.common.util.StreamUtil;

class HttpUtil {
    private HttpClient httpClient;
    private String baseUri;
    private Auth auth;

    HttpUtil(HttpClient httpClient, String baseUri) {
        this.httpClient = httpClient;
        this.baseUri = baseUri;
    }

    void setAuth(Auth auth) {
        this.auth = auth;
    }

    InputStream doPost(String content, String contentType, String acceptType, String ... path) throws ClientRegistrationException {
        try {
            HttpPost request = new HttpPost(HttpUtil.getUrl(this.baseUri, path));
            request.setHeader("Content-Type", contentType);
            request.setHeader("Accept", acceptType);
            request.setEntity((HttpEntity)new StringEntity(content));
            this.addAuth((HttpRequestBase)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                return responseStream;
            }
            throw this.httpErrorException(response, responseStream);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    InputStream doGet(String acceptType, String ... path) throws ClientRegistrationException {
        try {
            HttpGet request = new HttpGet(HttpUtil.getUrl(this.baseUri, path));
            request.setHeader("Accept", acceptType);
            this.addAuth((HttpRequestBase)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                return responseStream;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                responseStream.close();
                return null;
            }
            throw this.httpErrorException(response, responseStream);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    InputStream doPut(String content, String contentType, String acceptType, String ... path) throws ClientRegistrationException {
        try {
            HttpPut request = new HttpPut(HttpUtil.getUrl(this.baseUri, path));
            request.setHeader("Content-Type", contentType);
            request.setHeader("Accept", acceptType);
            request.setEntity((HttpEntity)new StringEntity(content));
            this.addAuth((HttpRequestBase)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                return responseStream;
            }
            throw this.httpErrorException(response, responseStream);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    void doDelete(String ... path) throws ClientRegistrationException {
        try {
            HttpDelete request = new HttpDelete(HttpUtil.getUrl(this.baseUri, path));
            this.addAuth((HttpRequestBase)request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            InputStream responseStream = null;
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            if (response.getStatusLine().getStatusCode() != 204) {
                throw this.httpErrorException(response, responseStream);
            }
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to send request", e);
        }
    }

    void close() throws ClientRegistrationException {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException e) {
                throw new ClientRegistrationException("Failed to close http client", e);
            }
        }
    }

    static String getUrl(String baseUri, String ... path) {
        StringBuilder s = new StringBuilder();
        s.append(baseUri);
        for (String p : path) {
            s.append('/');
            s.append(p);
        }
        return s.toString();
    }

    private void addAuth(HttpRequestBase request) {
        if (this.auth != null) {
            this.auth.addAuth((HttpRequest)request);
        }
    }

    private HttpErrorException httpErrorException(HttpResponse response, InputStream responseStream) throws IOException {
        if (responseStream != null) {
            String errorResponse = StreamUtil.readString((InputStream)responseStream);
            return new HttpErrorException(response.getStatusLine(), errorResponse);
        }
        return new HttpErrorException(response.getStatusLine(), null);
    }
}

