/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.complete.CompletionRegistration;
import org.jboss.aesh.console.AeshCompletionHandler;
import org.jboss.aesh.console.AeshConsoleBufferBuilder;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.AeshInputProcessorBuilder;
import org.jboss.aesh.console.CompletionHandler;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.InputProcessor;
import org.jboss.aesh.console.InputProcessorInterruptHook;
import org.jboss.aesh.console.Process;
import org.jboss.aesh.console.ProcessManager;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.alias.Alias;
import org.jboss.aesh.console.alias.AliasCompletion;
import org.jboss.aesh.console.alias.AliasManager;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.InternalCommands;
import org.jboss.aesh.console.export.ExportCompletion;
import org.jboss.aesh.console.export.ExportManager;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.console.operator.ControlOperatorParser;
import org.jboss.aesh.console.operator.RedirectionCompletion;
import org.jboss.aesh.console.reader.AeshStandardStream;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.history.History;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.util.FileUtils;
import org.jboss.aesh.util.LoggerUtil;

public class Console {
    private Settings settings;
    private ConsoleCallback consoleCallback;
    private volatile boolean running = false;
    private volatile boolean initiateStop = false;
    private volatile boolean reading = false;
    private volatile int[] readingInput = null;
    private volatile boolean processing = false;
    private ByteArrayOutputStream redirectPipeOutBuffer;
    private ByteArrayOutputStream redirectPipeErrBuffer;
    private List<ConsoleOperation> operations;
    private ConsoleOperation currentOperation;
    private AliasManager aliasManager;
    private ExportManager exportManager;
    private Shell shell;
    private ArrayBlockingQueue<CommandOperation> inputQueue;
    private ArrayBlockingQueue<int[]> cursorQueue;
    private volatile boolean readingCursor = false;
    private ExecutorService readerService;
    private ExecutorService executorService;
    private AeshContext context;
    private ProcessManager processManager;
    private ConsoleBuffer consoleBuffer;
    private InputProcessor inputProcessor;
    private CompletionHandler completionHandler;
    private AeshStandardStream standardStream;
    private boolean controlledMode = false;
    private static final Logger LOGGER = LoggerUtil.getLogger(Console.class.getName());

    public Console(Settings settings) {
        this.settings = settings;
        try {
            this.init();
        }
        catch (IOException e) {
            LOGGER.severe("\u00c6sh failed during setup: " + e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.settings != null) {
                if (this.settings.getTerminal() != null) {
                    this.settings.getTerminal().reset();
                }
                if (this.settings.getQuitHandler() != null) {
                    this.settings.getQuitHandler().quit();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Settings getSettings() {
        return this.settings;
    }

    private void init() throws IOException {
        if (this.running) {
            throw new RuntimeException("Cant reset an already running Console, must stop if first!");
        }
        if (this.readerService != null && !this.readerService.isShutdown()) {
            return;
        }
        if (this.settings.isLogging()) {
            LOGGER.info("RESET");
        }
        this.readerService = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("Aesh Read Loop " + runnable.hashCode());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("Aesh Process Loop " + runnable.hashCode());
                return thread;
            }
        });
        this.context = this.settings.getAeshContext();
        if (this.settings.doReadInputrc()) {
            this.settings = Config.parseInputrc(this.settings);
        }
        this.settings = Config.readRuntimeProperties(this.settings);
        this.settings.getTerminal().init(this.settings);
        EditMode editMode = this.settings.getEditMode();
        editMode.init(this);
        this.inputQueue = new ArrayBlockingQueue(50000);
        this.cursorQueue = new ArrayBlockingQueue(1);
        this.processManager = new ProcessManager(this, this.settings.isLogging());
        this.operations = new ArrayList<ConsoleOperation>();
        this.currentOperation = null;
        this.standardStream = new AeshStandardStream();
        this.redirectPipeOutBuffer = new ByteArrayOutputStream();
        this.redirectPipeErrBuffer = new ByteArrayOutputStream();
        this.shell = new ConsoleShell(this.getInternalShell(), this);
        this.consoleBuffer = new AeshConsoleBufferBuilder().shell(this.shell).editMode(editMode).ansi(this.settings.isAnsiConsole()).create();
        this.completionHandler = new AeshCompletionHandler(this.context, this.consoleBuffer, this.shell, this.settings.isOperatorParserEnabled(), true);
        if (!this.settings.isCompletionDisabled() && this.settings.isOperatorParserEnabled()) {
            this.completionHandler.addCompletion(new RedirectionCompletion());
        }
        if (this.settings.isAliasEnabled()) {
            if (this.settings.isLogging()) {
                LOGGER.info("enable aliasmanager with file: " + this.settings.getAliasFile());
            }
            this.aliasManager = new AliasManager(this.settings.getAliasFile(), this.settings.doPersistAlias(), this.settings.getName());
            this.completionHandler.addCompletion(new AliasCompletion(this.aliasManager));
            this.completionHandler.setAliasManager(this.aliasManager);
        }
        if (this.settings.isExportEnabled()) {
            if (this.settings.isLogging()) {
                LOGGER.info("enabling exportManager with file: " + this.settings.getExportFile());
            }
            this.exportManager = new ExportManager(this.settings.getExportFile(), this.settings.doExportUsesSystemEnvironment());
            this.completionHandler.addCompletion(new ExportCompletion(this.exportManager));
        }
        InputProcessorInterruptHook interruptHook = new InputProcessorInterruptHook(){

            @Override
            public void handleInterrupt(Action action) {
                if (Console.this.settings.hasInterruptHook()) {
                    Console.this.settings.getInterruptHook().handleInterrupt(Console.this, action);
                } else if (action == Action.IGNOREEOF) {
                    Console.this.displayPrompt();
                } else {
                    Console.this.stop();
                    if (Console.this.processManager.hasForegroundProcess()) {
                        Console.this.stop();
                    } else {
                        try {
                            Console.this.doStop();
                        }
                        catch (IOException e) {
                            LOGGER.warning("Failed to stop aesh! " + e.getMessage());
                        }
                    }
                }
            }
        };
        this.inputProcessor = new AeshInputProcessorBuilder().consoleBuffer(this.consoleBuffer).completion(this.completionHandler).settings(this.settings).interruptHook(interruptHook).create();
    }

    public TerminalSize getTerminalSize() {
        return this.getInternalShell().getSize();
    }

    public History getHistory() {
        return this.inputProcessor.getHistory();
    }

    public void setPrompt(Prompt prompt) {
        this.consoleBuffer.setPrompt(prompt);
    }

    public void updatePrompt(Prompt prompt) {
        this.consoleBuffer.updatePrompt(prompt);
    }

    public Prompt getPrompt() {
        return this.consoleBuffer.getBuffer().getPrompt();
    }

    public ExportManager getExportManager() {
        return this.exportManager;
    }

    public void setConsoleCallback(ConsoleCallback consoleCallback) {
        this.consoleCallback = consoleCallback;
    }

    public ConsoleCallback getConsoleCallback() {
        return this.consoleCallback;
    }

    public void changeOutputStream(PrintStream output) {
        if (output != null) {
            this.consoleBuffer.changeOutputBuffer(output);
            this.getTerminal().changeOutputStream(output);
        }
    }

    public boolean isWaiting() {
        return !this.processing && !this.processManager.hasForegroundProcess() && !this.getTerminal().hasInput() && this.readingInput == null && !this.hasInput();
    }

    public boolean isWaitingWithoutBackgroundProcess() {
        return !this.processing && !this.processManager.hasProcesses() && !this.getTerminal().hasInput() && this.readingInput == null && !this.hasInput();
    }

    public void controlled() {
        this.controlledMode = true;
    }

    public void continuous() {
        this.controlledMode = false;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("Not allowed to start the Console without stopping it first");
        }
        if (this.consoleCallback == null) {
            throw new IllegalStateException("Not possible to start the Console without setting ConsoleCallback");
        }
        this.running = true;
        this.displayPrompt();
        this.startReader();
        this.startExecutor();
        this.consoleBuffer.setPrompted(false);
        if (this.settings.getExecuteAtStart() != null) {
            this.pushToInputStream(this.settings.getExecuteAtStart());
        }
        if (this.settings.getExecuteFileAtStart() != null) {
            this.readExecuteFile();
        }
    }

    private PrintStream out() {
        if (this.currentOperation != null && this.currentOperation.getControlOperator().isRedirectionOut()) {
            return new PrintStream(this.redirectPipeOutBuffer, true);
        }
        return this.getShell().out();
    }

    private PrintStream err() {
        if (this.currentOperation != null && this.currentOperation.getControlOperator().isRedirectionErr()) {
            return new PrintStream(this.redirectPipeErrBuffer, true);
        }
        return this.getInternalShell().err();
    }

    private AeshStandardStream in() {
        return this.standardStream;
    }

    public AeshContext getAeshContext() {
        return this.context;
    }

    public void setEcho(boolean echo) {
        this.consoleBuffer.getBuffer().setEcho(echo);
    }

    public CompletionRegistration addCompletion(final Completion completion) {
        this.completionHandler.addCompletion(completion);
        return new CompletionRegistration(){

            @Override
            public void removeCompletion() {
                Console.this.completionHandler.removeCompletion(completion);
            }
        };
    }

    public void setCompletionEnabled(boolean completionEnabled) {
        this.completionHandler.setEnabled(completionEnabled);
    }

    public void stop() {
        this.initiateStop = true;
        try {
            this.doStop();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Got exception during stop: ", e);
        }
    }

    private synchronized void doStop() throws IOException {
        if (this.running) {
            this.running = false;
            if (this.initiateStop) {
                this.initiateStop = false;
            }
            int counter = 0;
            while (!this.inputQueue.isEmpty() && counter < 10) {
                try {
                    Thread.sleep(10L);
                    ++counter;
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Exception while waiting on inputqueue to flush: ", e);
                }
            }
            if (counter == 10) {
                LOGGER.log(Level.WARNING, "InputQueue still contains items after stop: " + this.inputQueue.toString());
            }
            this.inputProcessor.getHistory().stop();
            if (this.aliasManager != null) {
                this.aliasManager.persist();
            }
            if (this.exportManager != null) {
                this.exportManager.persistVariables();
            }
            this.processManager.stop();
            this.readerService.shutdown();
            this.executorService.shutdown();
            if (this.settings.isLogging()) {
                LOGGER.info("Done stopping services. Terminal is reset");
            }
        }
        this.getTerminal().close();
        this.getTerminal().reset();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void clearBufferAndDisplayPrompt() {
        this.inputProcessor.clearBufferAndDisplayPrompt();
    }

    protected CommandOperation getInput() throws InterruptedException {
        return this.inputQueue.take();
    }

    protected InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    public void putProcessInBackground(int pid) {
        this.processManager.putProcessInBackground(pid);
    }

    public void putProcessInForeground(int pid) {
        this.processManager.putProcessInForeground(pid);
    }

    public void pushToInputStream(String input) {
        this.getTerminal().writeToInputStream(input);
    }

    public boolean hasInput() {
        return this.inputQueue.size() > 0;
    }

    public boolean hasRunningProcesses() {
        return this.processManager.hasForegroundProcess();
    }

    public String getInputLine() throws InterruptedException {
        try {
            String result;
            while ((result = this.inputProcessor.parseOperation(this.getInput())) == null) {
            }
            return result;
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "GOT INTERRUPTED: ", e);
            throw e;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Failure while reading input: ", ioe);
            return null;
        }
    }

    private Shell getInternalShell() {
        return this.settings.getTerminal().getShell();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void currentProcessFinished(Process process) {
        if (this.currentOperation != null) {
            ConsoleOperation tmpOutput = null;
            try {
                tmpOutput = this.parseCurrentOperation();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tmpOutput != null && !this.readerService.isShutdown()) {
                this.processManager.startNewProcess(this.consoleCallback, tmpOutput);
            }
            this.inputProcessor.clearBufferAndDisplayPrompt();
        } else if (this.running || !this.inputQueue.isEmpty()) {
            this.inputProcessor.resetBuffer();
            if (!this.consoleBuffer.isPrompted()) {
                this.displayPrompt();
            }
        }
        this.consoleBuffer.setPrompted(false);
    }

    private Terminal getTerminal() {
        return this.settings.getTerminal();
    }

    public String getBuffer() {
        if (this.consoleBuffer.getBuffer() == null) {
            return "";
        }
        return this.consoleBuffer.getBuffer().getLineNoMask();
    }

    private void startReader() {
        this.reading = true;
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    while (Console.this.read()) {
                    }
                }
                finally {
                    Console.this.reading = false;
                }
            }
        };
        this.readerService.execute(reader);
    }

    private void startExecutor() {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Console.this.executorService.isShutdown()) {
                        Console.this.execute();
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.WARNING, "Exception while executing:", ie);
                }
                finally {
                    if (!Console.this.initiateStop || Console.this.running) {
                        Console.this.stop();
                    }
                }
            }
        };
        this.executorService.execute(reader);
    }

    private boolean read() {
        try {
            this.readingInput = this.getTerminal().read();
            if (this.settings.isLogging()) {
                LOGGER.info("GOT: " + Arrays.toString(this.readingInput));
            }
            if (this.readingCursor && this.readingInput.length > 4) {
                this.cursorQueue.add(this.readingInput);
                this.readingCursor = false;
                boolean bl = true;
                return bl;
            }
            if (this.readingInput.length == 0 || this.readingInput[0] == -1 || this.initiateStop) {
                LOGGER.info("Received null input or -1, or stop() has been called, stop reading");
                boolean bl = false;
                return bl;
            }
            this.parseInput(this.readingInput);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (this.settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "Stream failure, stopping Aesh: ", ioe);
            }
            this.stop();
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            if (this.settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "Stream failure, stopping Aesh: ", e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readingInput = null;
        }
    }

    private void parseInput(int[] input) throws InterruptedException {
        boolean parsing = true;
        int position = 0;
        while (parsing) {
            Key inc = Key.findStartKey(input, position);
            if (input.length > inc.getKeyValues().length + position) {
                position += inc.getKeyValues().length;
            } else {
                parsing = false;
            }
            if ((inc == Key.CTRL_C || inc == Key.CTRL_D) && this.processManager.hasForegroundProcess()) {
                try {
                    if (this.settings.isLogging()) {
                        LOGGER.info("killing process: " + this.processManager.getCurrentProcess().getPID());
                    }
                    this.processManager.getCurrentProcess().interrupt();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                continue;
            }
            this.inputQueue.put(new CommandOperation(inc, input, position));
        }
    }

    private void execute() {
        while (!this.processManager.hasForegroundProcess() && this.hasInput() && !this.controlledMode) {
            this.processing = true;
            try {
                this.processInternalOperation(this.getInput());
            }
            catch (IOException | InterruptedException e) {
                if (!this.settings.isLogging()) continue;
                LOGGER.warning("Execution exception: " + e.getMessage());
            }
            finally {
                this.processing = false;
            }
        }
        if (!(this.processManager.hasProcesses() || this.hasInput() || this.reading)) {
            this.consoleBuffer.out().print(Config.getLineSeparator());
            this.stop();
        }
    }

    private void execute(String command) throws InterruptedException {
        block5: {
            try {
                int start;
                int end = command.length();
                for (start = 0; start < end && Character.isWhitespace(command.charAt(start)); ++start) {
                }
                while (end > start && Character.isWhitespace(command.charAt(end - 1))) {
                    --end;
                }
                command = command.substring(start, end);
                ConsoleOperation output = new ConsoleOperation(ControlOperator.NONE, command);
                if ((output = this.processInternalCommands(output)).getBuffer() != null) {
                    this.consoleCallback.execute(output);
                }
            }
            catch (IOException ioe) {
                if (!this.settings.isLogging()) break block5;
                LOGGER.severe("Stream failure: " + ioe);
            }
        }
    }

    private void processInternalOperation(CommandOperation commandOperation) throws IOException {
        String result = this.inputProcessor.parseOperation(commandOperation);
        if (result != null) {
            this.processOperationResult(result);
        }
    }

    private void processOperationResult(String result) {
        block8: {
            try {
                if (result.length() == 0 && this.running) {
                    this.inputProcessor.clearBufferAndDisplayPrompt();
                    return;
                }
                if (result.startsWith(" ")) {
                    result = Parser.trimInFront(result);
                }
                if (this.settings.isOperatorParserEnabled()) {
                    this.operations = ControlOperatorParser.findAllControlOperators(result);
                } else {
                    this.operations = new ArrayList<ConsoleOperation>(1);
                    this.operations.add(new ConsoleOperation(ControlOperator.NONE, result));
                }
                ConsoleOperation output = this.parseOperations();
                output = this.processInternalCommands(output);
                if (output.getBuffer() != null) {
                    this.processManager.startNewProcess(this.consoleCallback, output);
                } else {
                    this.inputProcessor.clearBufferAndDisplayPrompt();
                }
            }
            catch (IOException ioe) {
                if (!this.settings.isLogging()) break block8;
                LOGGER.severe("Stream failure: " + ioe);
            }
        }
    }

    private void displayPrompt() {
        this.consoleBuffer.displayPrompt();
    }

    public void clear() throws IOException {
        this.consoleBuffer.clear(false);
    }

    private ConsoleOperation parseCurrentOperation() throws IOException {
        if (this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_OUT || this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_ERR || this.currentOperation.getControlOperator() == ControlOperator.APPEND_OUT || this.currentOperation.getControlOperator() == ControlOperator.APPEND_ERR || this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_OUT_AND_ERR) {
            ConsoleOperation nextOperation = this.operations.remove(0);
            this.persistRedirection(nextOperation.getBuffer(), this.currentOperation.getControlOperator());
            if (nextOperation.getControlOperator() == ControlOperator.NONE) {
                this.redirectPipeErrBuffer = new ByteArrayOutputStream();
                this.redirectPipeOutBuffer = new ByteArrayOutputStream();
                this.currentOperation = null;
                return null;
            }
            this.redirectPipeErrBuffer = new ByteArrayOutputStream();
            this.redirectPipeOutBuffer = new ByteArrayOutputStream();
            this.currentOperation = nextOperation;
            return this.parseCurrentOperation();
        }
        if (this.currentOperation.getControlOperator() == ControlOperator.PIPE || this.currentOperation.getControlOperator() == ControlOperator.PIPE_OUT_AND_ERR) {
            return this.parseOperations();
        }
        if (this.currentOperation.getControlOperator() == ControlOperator.END) {
            if (this.operations.size() > 0) {
                this.currentOperation = this.operations.remove(0);
                return this.currentOperation;
            }
            this.currentOperation = null;
            return null;
        }
        if (this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_IN) {
            if (this.settings.isLogging()) {
                LOGGER.info(this.settings.getName() + ": syntax error while reading token: '<'");
            }
            this.err().print(this.settings.getName() + ": syntax error while reading token: '<'");
            return null;
        }
        this.currentOperation = null;
        return null;
    }

    private ConsoleOperation parseOperations() throws IOException {
        ConsoleOperation output = null;
        ConsoleOperation op = this.operations.remove(0);
        if (op.getControlOperator() == ControlOperator.OVERWRITE_OUT || op.getControlOperator() == ControlOperator.OVERWRITE_ERR || op.getControlOperator() == ControlOperator.APPEND_OUT || op.getControlOperator() == ControlOperator.APPEND_ERR || op.getControlOperator() == ControlOperator.OVERWRITE_OUT_AND_ERR || op.getControlOperator() == ControlOperator.PIPE_OUT_AND_ERR || op.getControlOperator() == ControlOperator.PIPE) {
            if (this.operations.size() != 0) {
                this.currentOperation = op;
                if (op.getControlOperator().isRedirectionOut()) {
                    this.standardStream.setStdIn(new BufferedInputStream(new ByteArrayInputStream(this.redirectPipeOutBuffer.toString().getBytes())));
                }
                if (op.getControlOperator().isRedirectionErr()) {
                    this.standardStream.setStdError(new BufferedInputStream(new ByteArrayInputStream(this.redirectPipeErrBuffer.toString().getBytes())));
                }
                output = op;
            }
        } else if (op.getControlOperator() == ControlOperator.OVERWRITE_IN) {
            if (this.operations.size() > 0) {
                ConsoleOperation nextOperation = this.operations.remove(0);
                if (nextOperation.getBuffer().length() > 0) {
                    AeshLine line = Parser.findAllWords(nextOperation.getBuffer());
                    this.currentOperation = new ConsoleOperation(nextOperation.getControlOperator(), op.getBuffer());
                    Resource fileRelativePath = this.getAeshContext().getCurrentWorkingDirectory().newInstance(Parser.switchEscapedSpacesToSpacesInWord(line.getWords().get(0)));
                    Resource readFile = fileRelativePath.resolve(this.context.getCurrentWorkingDirectory()).get(0);
                    if (readFile.isLeaf()) {
                        this.standardStream.setStdIn(new BufferedInputStream(readFile.read()));
                        output = new ConsoleOperation(nextOperation.getControlOperator(), op.getBuffer());
                    } else {
                        this.err().println(this.settings.getName() + ": " + readFile.toString() + " no such file.");
                        this.currentOperation = null;
                        output = new ConsoleOperation(ControlOperator.NONE, op.getBuffer());
                    }
                } else {
                    if (this.settings.isLogging()) {
                        LOGGER.info(this.settings.getName() + ": syntax error near unexpected token '<'" + Config.getLineSeparator());
                    }
                    this.err().print(this.settings.getName() + ": syntax error near unexpected token '<'" + Config.getLineSeparator());
                    this.currentOperation = null;
                    output = new ConsoleOperation(ControlOperator.NONE, "");
                }
            } else {
                if (this.settings.isLogging()) {
                    LOGGER.info(this.settings.getName() + ": syntax error near unexpected token 'newline'" + Config.getLineSeparator());
                }
                this.err().print(this.settings.getName() + ": syntax error near unexpected token 'newline'" + Config.getLineSeparator());
                this.currentOperation = null;
                output = new ConsoleOperation(ControlOperator.NONE, "");
            }
        } else if (op.getControlOperator() == ControlOperator.END) {
            this.currentOperation = op;
            output = op;
        } else {
            this.currentOperation = null;
            this.standardStream.setStdIn(new BufferedInputStream(new ByteArrayInputStream(this.redirectPipeOutBuffer.toString().getBytes())));
            this.standardStream.setStdError(new BufferedInputStream(new ByteArrayInputStream(this.redirectPipeErrBuffer.toString().getBytes())));
            output = op;
        }
        if (this.redirectPipeOutBuffer.toString().length() > 0) {
            this.redirectPipeOutBuffer = new ByteArrayOutputStream();
        }
        if (this.redirectPipeErrBuffer.toString().length() > 0) {
            this.redirectPipeErrBuffer = new ByteArrayOutputStream();
        }
        this.out().flush();
        if (output != null) {
            return this.findAliases(output);
        }
        return new ConsoleOperation(ControlOperator.NONE, "");
    }

    private ConsoleOperation processInternalCommands(ConsoleOperation output) throws IOException {
        if (output.getBuffer() != null) {
            if (this.settings.isAliasEnabled() && output.getBuffer().startsWith(InternalCommands.ALIAS.getCommand())) {
                String out = this.aliasManager.parseAlias(output.getBuffer().trim());
                if (out != null) {
                    this.out().print(out);
                    this.out().flush();
                }
                return new ConsoleOperation(ControlOperator.NONE, null);
            }
            if (this.settings.isAliasEnabled() && output.getBuffer().startsWith(InternalCommands.UNALIAS.getCommand())) {
                String out = this.aliasManager.removeAlias(output.getBuffer().trim());
                if (out != null) {
                    this.out().print(out);
                    this.out().flush();
                }
                return new ConsoleOperation(ControlOperator.NONE, null);
            }
            if (this.settings.isExportEnabled() && output.getBuffer().startsWith(InternalCommands.EXPORT.getCommand())) {
                if (output.getBuffer().trim().equals(InternalCommands.EXPORT.getCommand())) {
                    this.out().print(this.exportManager.listAllVariables());
                } else {
                    String out = this.exportManager.addVariable(output.getBuffer());
                    if (out != null) {
                        this.out().println(out);
                        this.out().flush();
                    }
                }
                return new ConsoleOperation(ControlOperator.NONE, null);
            }
        }
        return output;
    }

    private ConsoleOperation findAliases(ConsoleOperation operation) {
        String command;
        Alias alias;
        if (this.settings.isExportEnabled() && Parser.containsNonEscapedDollar(operation.getBuffer())) {
            operation = new ConsoleOperation(operation.getControlOperator(), this.exportManager.getValue(operation.getBuffer()));
        }
        if (this.settings.isAliasEnabled() && (alias = this.aliasManager.getAlias(command = Parser.findFirstWord(operation.getBuffer()))) != null) {
            operation = new ConsoleOperation(operation.getControlOperator(), alias.getValue() + operation.getBuffer().substring(command.length()));
        }
        return operation;
    }

    private void persistRedirection(String fileName, ControlOperator redirection) throws IOException {
        AeshLine line = Parser.findAllWords(fileName);
        if (line.getWords().size() > 1) {
            if (this.settings.isLogging()) {
                LOGGER.info(this.settings.getName() + ": can't redirect to more than one file." + Config.getLineSeparator());
            }
            this.err().print(this.settings.getName() + ": can't redirect to more than one file." + Config.getLineSeparator());
            return;
        }
        fileName = line.getWords().get(0);
        if (fileName.startsWith("~/")) {
            fileName = Config.getHomeDir() + fileName.substring(1);
        }
        try {
            if (redirection == ControlOperator.OVERWRITE_OUT) {
                FileUtils.saveFile(this.context.getCurrentWorkingDirectory().newInstance(Parser.switchEscapedSpacesToSpacesInWord(fileName)).resolve(this.context.getCurrentWorkingDirectory()).get(0), this.redirectPipeOutBuffer.toString(), false);
            } else if (redirection == ControlOperator.OVERWRITE_ERR) {
                FileUtils.saveFile(this.context.getCurrentWorkingDirectory().newInstance(Parser.switchEscapedSpacesToSpacesInWord(fileName)).resolve(this.context.getCurrentWorkingDirectory()).get(0), this.redirectPipeErrBuffer.toString(), false);
            } else if (redirection == ControlOperator.APPEND_OUT) {
                FileUtils.saveFile(this.context.getCurrentWorkingDirectory().newInstance(Parser.switchEscapedSpacesToSpacesInWord(fileName)).resolve(this.context.getCurrentWorkingDirectory()).get(0), this.redirectPipeOutBuffer.toString(), true);
            } else if (redirection == ControlOperator.APPEND_ERR) {
                FileUtils.saveFile(this.context.getCurrentWorkingDirectory().newInstance(Parser.switchEscapedSpacesToSpacesInWord(fileName)).resolve(this.context.getCurrentWorkingDirectory()).get(0), this.redirectPipeErrBuffer.toString(), true);
            }
        }
        catch (IOException e) {
            if (this.settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "Saving file " + fileName + " to disk failed: ", e);
            }
            this.getInternalShell().err().println(e.getMessage());
            this.err().flush();
        }
        this.redirectPipeOutBuffer = new ByteArrayOutputStream();
        this.redirectPipeErrBuffer = new ByteArrayOutputStream();
    }

    private void readExecuteFile() {
        if (this.settings.getExecuteFileAtStart() != null && this.settings.getExecuteFileAtStart().isLeaf()) {
            LOGGER.info("reading file");
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.settings.getExecuteFileAtStart().read()));
                while ((line = reader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    LOGGER.info("pushing: " + line);
                    this.execute(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEchoing() {
        return this.consoleBuffer.getBuffer().isEchoing();
    }

    private static class ConsoleShell
    implements Shell {
        private final Console console;
        private final Shell shell;

        ConsoleShell(Shell shell, Console console) {
            this.shell = shell;
            this.console = console;
        }

        @Override
        public void clear() throws IOException {
            this.shell.clear();
        }

        @Override
        public PrintStream out() {
            return this.console.getInternalShell().out();
        }

        @Override
        public PrintStream err() {
            return this.console.err();
        }

        @Override
        public AeshStandardStream in() {
            return this.console.in();
        }

        @Override
        public TerminalSize getSize() {
            return this.console.getTerminalSize();
        }

        @Override
        public CursorPosition getCursor() {
            if (this.console.settings.isAnsiConsole() && Config.isOSPOSIXCompatible()) {
                try {
                    this.out().print("\u001b[6n");
                    this.out().flush();
                    this.console.readingCursor = true;
                    return this.getActualCursor((int[])this.console.cursorQueue.take());
                }
                catch (Exception e) {
                    if (this.console.settings.isLogging()) {
                        LOGGER.log(Level.SEVERE, "Failed to find current row with ansi code: ", e);
                    }
                    return new CursorPosition(-1, -1);
                }
            }
            return new CursorPosition(-1, -1);
        }

        private CursorPosition getActualCursor(int[] input) {
            boolean started = false;
            boolean gotSep = false;
            int col = 0;
            int row = 0;
            for (int i = 0; i < input.length - 1; ++i) {
                if (started) {
                    char c;
                    if (input[i] == 82) break;
                    if (input[i] == 59) {
                        gotSep = true;
                        continue;
                    }
                    if (gotSep) {
                        c = (char)input[i];
                        col *= 10;
                        col += c & 0xF;
                        continue;
                    }
                    c = (char)input[i];
                    row *= 10;
                    row += c & 0xF;
                    continue;
                }
                if (input[i] != Key.ESC.getFirstValue() || i >= input.length - 1 || input[i + 1] != Key.LEFT_SQUARE_BRACKET.getFirstValue()) continue;
                started = true;
                ++i;
            }
            return new CursorPosition(row, col);
        }

        @Override
        public void setCursor(CursorPosition position) {
            this.shell.setCursor(position);
        }

        @Override
        public void moveCursor(int rows, int columns) {
            this.shell.moveCursor(rows, columns);
        }

        @Override
        public boolean isMainBuffer() {
            return this.shell.isMainBuffer();
        }

        @Override
        public void enableAlternateBuffer() {
            this.shell.enableAlternateBuffer();
        }

        @Override
        public void enableMainBuffer() {
            this.shell.enableMainBuffer();
        }
    }
}

