/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;

public class AuthorizationRequest {
    private String ticket;
    private String rpt;
    private String claimToken;
    private String claimTokenFormat;
    private String pct;
    private String scope;
    private PermissionTicketToken permissions = new PermissionTicketToken();
    private Metadata metadata;
    private String audience;
    private String accessToken;
    private boolean submitRequest;

    public AuthorizationRequest(String ticket) {
        this.ticket = ticket;
    }

    public AuthorizationRequest() {
        this(null);
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getRpt() {
        return this.rpt;
    }

    public void setRpt(String rpt) {
        this.rpt = rpt;
    }

    public void setClaimToken(String claimToken) {
        this.claimToken = claimToken;
    }

    public String getClaimToken() {
        return this.claimToken;
    }

    public void setClaimTokenFormat(String claimTokenFormat) {
        this.claimTokenFormat = claimTokenFormat;
    }

    public String getClaimTokenFormat() {
        return this.claimTokenFormat;
    }

    public void setPct(String pct) {
        this.pct = pct;
    }

    public String getPct() {
        return this.pct;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setPermissions(PermissionTicketToken permissions) {
        this.permissions = permissions;
    }

    public PermissionTicketToken getPermissions() {
        return this.permissions;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void addPermission(String resourceId, List<String> scopes) {
        this.addPermission(resourceId, scopes.toArray(new String[scopes.size()]));
    }

    public void addPermission(String resourceId, String ... scopes) {
        if (this.permissions == null) {
            this.permissions = new PermissionTicketToken(new ArrayList<PermissionTicketToken.ResourcePermission>());
        }
        PermissionTicketToken.ResourcePermission permission = null;
        for (PermissionTicketToken.ResourcePermission resourcePermission : this.permissions.getResources()) {
            if (!resourcePermission.getResourceId().equals(resourceId)) continue;
            permission = resourcePermission;
            break;
        }
        if (permission == null) {
            permission = new PermissionTicketToken.ResourcePermission(resourceId, new HashSet<String>());
            this.permissions.getResources().add(permission);
        }
        permission.getScopes().addAll(Arrays.asList(scopes));
    }

    public void setSubmitRequest(boolean submitRequest) {
        this.submitRequest = submitRequest;
    }

    public boolean isSubmitRequest() {
        return this.submitRequest && this.ticket != null;
    }

    public static class Metadata {
        private Boolean includeResourceName;
        private Integer limit;

        public Boolean getIncludeResourceName() {
            if (this.includeResourceName == null) {
                this.includeResourceName = Boolean.TRUE;
            }
            return this.includeResourceName;
        }

        public void setIncludeResourceName(Boolean includeResourceName) {
            this.includeResourceName = includeResourceName;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }
    }
}

