/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events;

import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;

public class EventBuilder {
    private static final Logger log = Logger.getLogger(EventBuilder.class);
    private List<EventListenerProvider> listeners;
    private Event event;

    public EventBuilder(List<EventListenerProvider> listeners, RealmModel realm, String ipAddress) {
        this.listeners = listeners;
        this.event = new Event();
        this.realm(realm);
        this.ipAddress(ipAddress);
    }

    EventBuilder() {
    }

    public EventBuilder realm(RealmModel realm) {
        this.event.setRealmId(realm.getId());
        return this;
    }

    public EventBuilder realm(String realmId) {
        this.event.setRealmId(realmId);
        return this;
    }

    public EventBuilder client(ClientModel client) {
        this.event.setClientId(client.getClientId());
        return this;
    }

    public EventBuilder client(String clientId) {
        this.event.setClientId(clientId);
        return this;
    }

    public EventBuilder user(UserModel user) {
        this.event.setUserId(user.getId());
        return this;
    }

    public EventBuilder user(String userId) {
        this.event.setUserId(userId);
        return this;
    }

    public EventBuilder session(UserSessionModel session) {
        this.event.setSessionId(session.getId());
        return this;
    }

    public EventBuilder session(String sessionId) {
        this.event.setSessionId(sessionId);
        return this;
    }

    public EventBuilder ipAddress(String ipAddress) {
        this.event.setIpAddress(ipAddress);
        return this;
    }

    public EventBuilder event(EventType e) {
        this.event.setType(e);
        return this;
    }

    public EventBuilder detail(String key, String value) {
        if (value == null || value.equals("")) {
            return this;
        }
        if (this.event.getDetails() == null) {
            this.event.setDetails(new HashMap<String, String>());
        }
        this.event.getDetails().put(key, value);
        return this;
    }

    public EventBuilder removeDetail(String key) {
        if (this.event.getDetails() != null) {
            this.event.getDetails().remove(key);
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public void success() {
        this.send();
    }

    public void error(String error) {
        this.event.setType(EventType.valueOf(this.event.getType().name() + "_ERROR"));
        this.event.setError(error);
        this.send();
    }

    public EventBuilder clone() {
        EventBuilder clone = new EventBuilder();
        clone.listeners = this.listeners;
        clone.event = this.event.clone();
        return clone;
    }

    public EventBuilder reset() {
        Event old = this.event;
        this.event = new Event();
        this.event.setRealmId(old.getRealmId());
        this.event.setIpAddress(old.getIpAddress());
        this.event.setClientId(old.getClientId());
        this.event.setUserId(old.getUserId());
        return this;
    }

    private void send() {
        this.event.setTime(System.currentTimeMillis());
        if (this.listeners != null) {
            for (EventListenerProvider l : this.listeners) {
                try {
                    l.onEvent(this.event);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to send type to " + l), t);
                }
            }
        }
    }
}

