/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.email;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserModel;

public class EmailEventListenerProvider
implements EventListenerProvider {
    private static final Logger log = Logger.getLogger(EmailEventListenerProvider.class);
    private KeycloakSession session;
    private RealmProvider model;
    private EmailProvider emailProvider;
    private Set<EventType> includedEvents;

    public EmailEventListenerProvider(KeycloakSession session, EmailProvider emailProvider, Set<EventType> includedEvents) {
        this.session = session;
        this.model = session.realms();
        this.emailProvider = emailProvider;
        this.includedEvents = includedEvents;
    }

    public void onEvent(Event event) {
        if (this.includedEvents.contains(event.getType()) && event.getRealmId() != null && event.getUserId() != null) {
            RealmModel realm = this.model.getRealm(event.getRealmId());
            UserModel user = this.session.users().getUserById(event.getUserId(), realm);
            if (user != null && user.getEmail() != null && user.isEmailVerified()) {
                try {
                    this.emailProvider.setRealm(realm).setUser(user).sendEvent(event);
                }
                catch (EmailException e) {
                    log.error((Object)"Failed to send type mail", (Throwable)e);
                }
            }
        }
    }

    public void close() {
    }
}

