/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.log;

import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;

public class JBossLoggingEventListenerProvider
implements EventListenerProvider {
    private final KeycloakSession session;
    private final Logger logger;
    private final Logger.Level successLevel;
    private final Logger.Level errorLevel;

    public JBossLoggingEventListenerProvider(KeycloakSession session, Logger logger, Logger.Level successLevel, Logger.Level errorLevel) {
        this.session = session;
        this.logger = logger;
        this.successLevel = successLevel;
        this.errorLevel = errorLevel;
    }

    public void onEvent(Event event) {
        Logger.Level level;
        Logger.Level level2 = level = event.getError() != null ? this.errorLevel : this.successLevel;
        if (this.logger.isEnabled(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append("type=");
            sb.append(event.getType());
            sb.append(", realmId=");
            sb.append(event.getRealmId());
            sb.append(", clientId=");
            sb.append(event.getClientId());
            sb.append(", userId=");
            sb.append(event.getUserId());
            sb.append(", ipAddress=");
            sb.append(event.getIpAddress());
            if (event.getError() != null) {
                sb.append(", error=");
                sb.append(event.getError());
            }
            if (event.getDetails() != null) {
                for (Map.Entry e : event.getDetails().entrySet()) {
                    sb.append(", ");
                    sb.append((String)e.getKey());
                    if (e.getValue() == null || ((String)e.getValue()).indexOf(32) == -1) {
                        sb.append("=");
                        sb.append((String)e.getValue());
                        continue;
                    }
                    sb.append("='");
                    sb.append((String)e.getValue());
                    sb.append("'");
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.setKeycloakContext(sb);
            }
            this.logger.log(this.logger.isTraceEnabled() ? Logger.Level.TRACE : level, (Object)sb.toString());
        }
    }

    public void onEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        Logger.Level level;
        Logger.Level level2 = level = adminEvent.getError() != null ? this.errorLevel : this.successLevel;
        if (this.logger.isEnabled(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append("operationType=");
            sb.append(adminEvent.getOperationType());
            sb.append(", realmId=");
            sb.append(adminEvent.getAuthDetails().getRealmId());
            sb.append(", clientId=");
            sb.append(adminEvent.getAuthDetails().getClientId());
            sb.append(", userId=");
            sb.append(adminEvent.getAuthDetails().getUserId());
            sb.append(", ipAddress=");
            sb.append(adminEvent.getAuthDetails().getIpAddress());
            sb.append(", resourcePath=");
            sb.append(adminEvent.getResourcePath());
            if (adminEvent.getError() != null) {
                sb.append(", error=");
                sb.append(adminEvent.getError());
            }
            if (this.logger.isTraceEnabled()) {
                this.setKeycloakContext(sb);
            }
            this.logger.log(this.logger.isTraceEnabled() ? Logger.Level.TRACE : level, (Object)sb.toString());
        }
    }

    public void close() {
    }

    private void setKeycloakContext(StringBuilder sb) {
        KeycloakContext context = this.session.getContext();
        UriInfo uriInfo = context.getUri();
        HttpHeaders headers = context.getRequestHeaders();
        if (uriInfo != null) {
            sb.append(", requestUri=");
            sb.append(uriInfo.getRequestUri().toString());
        }
        if (headers != null) {
            sb.append(", cookies=[");
            boolean f = true;
            for (Map.Entry e : headers.getCookies().entrySet()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(", ");
                }
                sb.append(((Cookie)e.getValue()).toString());
            }
            sb.append("]");
        }
    }
}

