/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.domainextension.rest;

import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.Path;
import org.keycloak.examples.domainextension.rest.CompanyResource;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class ExampleRestResource {
    private final KeycloakSession session;
    private final AuthenticationManager.AuthResult auth;

    public ExampleRestResource(KeycloakSession session) {
        this.session = session;
        this.auth = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
    }

    @Path(value="companies")
    public CompanyResource getCompanyResource() {
        return new CompanyResource(this.session);
    }

    @Path(value="companies-auth")
    public CompanyResource getCompanyResourceAuthenticated() {
        this.checkRealmAdmin();
        return new CompanyResource(this.session);
    }

    private void checkRealmAdmin() {
        if (this.auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (this.auth.getToken().getRealmAccess() == null || !this.auth.getToken().getRealmAccess().isUserInRole("admin")) {
            throw new ForbiddenException("Does not have realm admin role");
        }
    }
}

