/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.domainextension.spi.impl;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.examples.domainextension.CompanyRepresentation;
import org.keycloak.examples.domainextension.jpa.Company;
import org.keycloak.examples.domainextension.spi.ExampleService;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ExampleServiceImpl
implements ExampleService {
    private final KeycloakSession session;

    public ExampleServiceImpl(KeycloakSession session) {
        this.session = session;
        if (this.getRealm() == null) {
            throw new IllegalStateException("The service cannot accept a session without a realm in its context.");
        }
    }

    private EntityManager getEntityManager() {
        return ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    protected RealmModel getRealm() {
        return this.session.getContext().getRealm();
    }

    @Override
    public List<CompanyRepresentation> listCompanies() {
        List companyEntities = this.getEntityManager().createNamedQuery("findByRealm", Company.class).setParameter("realmId", (Object)this.getRealm().getId()).getResultList();
        LinkedList<CompanyRepresentation> result = new LinkedList<CompanyRepresentation>();
        for (Company entity : companyEntities) {
            result.add(new CompanyRepresentation(entity));
        }
        return result;
    }

    @Override
    public CompanyRepresentation findCompany(String id) {
        Company entity = (Company)this.getEntityManager().find(Company.class, (Object)id);
        return entity == null ? null : new CompanyRepresentation(entity);
    }

    @Override
    public CompanyRepresentation addCompany(CompanyRepresentation company) {
        Company entity = new Company();
        String id = company.getId() == null ? KeycloakModelUtils.generateId() : company.getId();
        entity.setId(id);
        entity.setName(company.getName());
        entity.setRealmId(this.getRealm().getId());
        this.getEntityManager().persist((Object)entity);
        company.setId(id);
        return company;
    }

    public void close() {
    }
}

