/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.maven.plugin.logging.Log;
import org.keycloak.guides.maven.Context;
import org.keycloak.guides.maven.FreeMarker;

public class GuideBuilder {
    private final FreeMarker freeMarker;
    private final File srcDir;
    private final File targetDir;
    private final Log log;

    public GuideBuilder(File srcDir, File targetDir, Log log) throws IOException {
        this.srcDir = srcDir;
        this.targetDir = targetDir;
        this.log = log;
        HashMap<String, Object> globalAttributes = new HashMap<String, Object>();
        globalAttributes.put("ctx", new Context(srcDir));
        this.freeMarker = new FreeMarker(srcDir, targetDir, globalAttributes);
    }

    public void server() throws TemplateException, IOException {
        File serverGuidesDir = new File(this.srcDir, "server");
        if (!serverGuidesDir.isDirectory()) {
            serverGuidesDir.mkdir();
        }
        for (String t : serverGuidesDir.list((dir, name) -> name.endsWith(".adoc"))) {
            this.freeMarker.template("server/" + t);
            if (this.log == null) continue;
            this.log.info((CharSequence)("Templated: server/" + t));
        }
    }
}

