/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.OAuthErrorException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterRSATokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class KeycloakInstalled {
    private static final String KEYCLOAK_JSON = "META-INF/keycloak.json";
    private KeycloakDeployment deployment;
    private AccessTokenResponse tokenResponse;
    private String tokenString;
    private String idTokenString;
    private IDToken idToken;
    private AccessToken token;
    private String refreshToken;
    private Status status;
    private Locale locale;
    private HttpResponseWriter loginResponseWriter;
    private HttpResponseWriter logoutResponseWriter;
    Pattern callbackPattern = Pattern.compile("callback\\s*=\\s*\"([^\"]+)\"");
    Pattern paramPattern = Pattern.compile("param=\"([^\"]+)\"\\s+label=\"([^\"]+)\"\\s+mask=(\\S+)");
    Pattern codePattern = Pattern.compile("code=([^&]+)");
    private static HttpResponseWriter defaultLoginWriter = new HttpResponseWriter(){

        @Override
        public void success(PrintWriter pw, KeycloakInstalled ki) {
            pw.println("HTTP/1.1 200 OK");
            pw.println("Content-Type: text/html");
            pw.println();
            pw.println("<html><h1>Login completed.</h1><div>");
            pw.println("This browser will remain logged in until you close it, logout, or the session expires.");
            pw.println("</div></html>");
            pw.flush();
        }

        @Override
        public void failure(PrintWriter pw, KeycloakInstalled ki) {
            pw.println("HTTP/1.1 200 OK");
            pw.println("Content-Type: text/html");
            pw.println();
            pw.println("<html><h1>Login attempt failed.</h1><div>");
            pw.println("</div></html>");
            pw.flush();
        }
    };
    private static HttpResponseWriter defaultLogoutWriter = new HttpResponseWriter(){

        @Override
        public void success(PrintWriter pw, KeycloakInstalled ki) {
            pw.println("HTTP/1.1 200 OK");
            pw.println("Content-Type: text/html");
            pw.println();
            pw.println("<html><h1>Logout completed.</h1><div>");
            pw.println("You may close this browser tab.");
            pw.println("</div></html>");
            pw.flush();
        }

        @Override
        public void failure(PrintWriter pw, KeycloakInstalled ki) {
            pw.println("HTTP/1.1 200 OK");
            pw.println("Content-Type: text/html");
            pw.println();
            pw.println("<html><h1>Logout failed.</h1><div>");
            pw.println("You may close this browser tab.");
            pw.println("</div></html>");
            pw.flush();
        }
    };

    public KeycloakInstalled() {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_JSON);
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public KeycloakInstalled(InputStream config) {
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public KeycloakInstalled(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public HttpResponseWriter getLoginResponseWriter() {
        if (this.loginResponseWriter == null) {
            return defaultLoginWriter;
        }
        return this.loginResponseWriter;
    }

    public HttpResponseWriter getLogoutResponseWriter() {
        if (this.logoutResponseWriter == null) {
            return defaultLogoutWriter;
        }
        return this.logoutResponseWriter;
    }

    public void setLoginResponseWriter(HttpResponseWriter loginResponseWriter) {
        this.loginResponseWriter = loginResponseWriter;
    }

    public void setLogoutResponseWriter(HttpResponseWriter logoutResponseWriter) {
        this.logoutResponseWriter = logoutResponseWriter;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void login() throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual();
        }
    }

    public void login(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual(printer, reader);
        }
    }

    public void logout() throws IOException, InterruptedException, URISyntaxException {
        if (this.status == Status.LOGGED_DESKTOP) {
            this.logoutDesktop();
        }
        this.tokenString = null;
        this.token = null;
        this.idTokenString = null;
        this.idToken = null;
        this.refreshToken = null;
        this.status = null;
    }

    public void loginDesktop() throws IOException, VerificationException, OAuthErrorException, URISyntaxException, ServerRequest.HttpFailure, InterruptedException {
        CallbackListener callback = new CallbackListener(this.getLoginResponseWriter());
        callback.start();
        String redirectUri = "http://localhost:" + callback.server.getLocalPort();
        String state = UUID.randomUUID().toString();
        KeycloakUriBuilder builder = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).queryParam("scope", new Object[]{"openid"});
        if (this.locale != null) {
            builder.queryParam("ui_locales", new Object[]{this.locale.getLanguage()});
        }
        String authUrl = builder.build(new Object[0]).toString();
        Desktop.getDesktop().browse(new URI(authUrl));
        callback.join();
        if (!state.equals(callback.state)) {
            throw new VerificationException("Invalid state");
        }
        if (callback.error != null) {
            throw new OAuthErrorException(callback.error, callback.errorDescription);
        }
        if (callback.errorException != null) {
            throw callback.errorException;
        }
        this.processCode(callback.code, redirectUri);
        this.status = Status.LOGGED_DESKTOP;
    }

    private void logoutDesktop() throws IOException, URISyntaxException, InterruptedException {
        CallbackListener callback = new CallbackListener(this.getLogoutResponseWriter());
        callback.start();
        String redirectUri = "http://localhost:" + callback.server.getLocalPort();
        String logoutUrl = this.deployment.getLogoutUrl().queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
        Desktop.getDesktop().browse(new URI(logoutUrl));
        callback.join();
        if (callback.errorException != null) {
            throw callback.errorException;
        }
    }

    public void loginManual() throws IOException, ServerRequest.HttpFailure, VerificationException {
        this.loginManual(System.out, new InputStreamReader(System.in));
    }

    public void loginManual(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        String authUrl = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("scope", new Object[]{"openid"}).build(new Object[0]).toString();
        printer.println("Open the following URL in a browser. After login copy/paste the code back and press <enter>");
        printer.println(authUrl);
        printer.println();
        printer.print("Code: ");
        String code = this.readCode(reader);
        this.processCode(code, redirectUri);
        this.status = Status.LOGGED_MANUAL;
    }

    public boolean loginCommandLine() throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        return this.loginCommandLine(redirectUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginCommandLine(String redirectUri) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String authUrl = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("scope", new Object[]{"openid"}).build(new Object[0]).toString();
        try (ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();){
            Matcher m;
            Form form;
            String callback;
            Response response = client.target(authUrl).request().get();
            if (response.getStatus() != 401) {
                boolean bl = false;
                return bl;
            }
            do {
                String authenticationHeader;
                if ((authenticationHeader = response.getHeaderString("WWW-Authenticate")) == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!authenticationHeader.contains("X-Text-Form-Challenge")) {
                    boolean bl = false;
                    return bl;
                }
                if (response.getMediaType() != null) {
                    String splash = (String)response.readEntity(String.class);
                    System.console().writer().println(splash);
                }
                if (!(m = this.callbackPattern.matcher(authenticationHeader)).find()) {
                    boolean bl = false;
                    return bl;
                }
                callback = m.group(1);
                m = this.paramPattern.matcher(authenticationHeader);
                form = new Form();
                while (m.find()) {
                    String param = m.group(1);
                    String label = m.group(2);
                    String mask = m.group(3).trim();
                    boolean maskInput = mask.equals("true");
                    String value = null;
                    if (maskInput) {
                        char[] txt = System.console().readPassword(label, new Object[0]);
                        value = new String(txt);
                    } else {
                        value = System.console().readLine(label, new Object[0]);
                    }
                    form.param(param, value);
                }
            } while ((response = client.target(callback).request().post(Entity.form((Form)form))).getStatus() == 401);
            if (response.getStatus() != 302) {
                boolean param = false;
                return param;
            }
            String location = response.getLocation().toString();
            m = this.codePattern.matcher(location);
            if (!m.find()) {
                boolean label = false;
                return label;
            }
            String code = m.group(1);
            this.processCode(code, redirectUri);
            boolean bl = true;
            return bl;
        }
    }

    public String getTokenString() throws VerificationException, IOException, ServerRequest.HttpFailure {
        return this.tokenString;
    }

    public String getTokenString(long minValidity, TimeUnit unit) throws VerificationException, IOException, ServerRequest.HttpFailure {
        long expires = (long)this.token.getExpiration() * 1000L - unit.toMillis(minValidity);
        if (expires < System.currentTimeMillis()) {
            this.refreshToken();
        }
        return this.tokenString;
    }

    public void refreshToken() throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)this.refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    public void refreshToken(String refreshToken) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    private void parseAccessToken(AccessTokenResponse tokenResponse) throws VerificationException {
        this.tokenResponse = tokenResponse;
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        this.token = AdapterRSATokenVerifier.verifyToken((String)this.tokenString, (KeycloakDeployment)this.deployment);
        if (this.idTokenString != null) {
            try {
                JWSInput input = new JWSInput(this.idTokenString);
                this.idToken = (IDToken)input.readJsonContent(IDToken.class);
            }
            catch (JWSInputException e) {
                throw new VerificationException();
            }
        }
    }

    public AccessToken getToken() {
        return this.token;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    public boolean isDesktopSupported() {
        return Desktop.isDesktopSupported();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private void processCode(String code, String redirectUri) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)this.deployment, (String)code, (String)redirectUri, null);
        this.parseAccessToken(tokenResponse);
    }

    private String readCode(Reader reader) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != ' ' && c != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String readMasked(Reader reader) {
        MaskingThread et = new MaskingThread();
        Thread mask = new Thread(et);
        mask.start();
        BufferedReader in = new BufferedReader(reader);
        String password = "";
        try {
            password = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        et.stopMasking();
        return password;
    }

    private String readLine(Reader reader, boolean mask) throws IOException {
        char c;
        if (mask) {
            System.out.print(" ");
            return KeycloakInstalled.readMasked(reader);
        }
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    public class CallbackListener
    extends Thread {
        private ServerSocket server;
        private String code;
        private String error;
        private String errorDescription;
        private IOException errorException;
        private String state;
        private Socket socket;
        private HttpResponseWriter writer;

        public CallbackListener(HttpResponseWriter writer) throws IOException {
            this.writer = writer;
            this.server = new ServerSocket(0);
        }

        @Override
        public void run() {
            try {
                this.socket = this.server.accept();
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String request = br.readLine();
                String url = request.split(" ")[1];
                if (url.indexOf(63) >= 0) {
                    String[] params;
                    url = url.split("\\?")[1];
                    for (String param : params = url.split("&")) {
                        String[] p = param.split("=");
                        if (p[0].equals("code")) {
                            this.code = p[1];
                            continue;
                        }
                        if (p[0].equals("error")) {
                            this.error = p[1];
                            continue;
                        }
                        if (p[0].equals("error-description")) {
                            this.errorDescription = p[1];
                            continue;
                        }
                        if (!p[0].equals("state")) continue;
                        this.state = p[1];
                    }
                }
                OutputStreamWriter out = new OutputStreamWriter(this.socket.getOutputStream());
                PrintWriter pw = new PrintWriter(out);
                if (this.error == null) {
                    this.writer.success(pw, KeycloakInstalled.this);
                } else {
                    this.writer.failure(pw, KeycloakInstalled.this);
                }
                pw.flush();
                this.socket.close();
            }
            catch (IOException e) {
                this.errorException = e;
            }
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)42;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    try {
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }

    private static enum Status {
        LOGGED_MANUAL,
        LOGGED_DESKTOP;

    }

    public static interface HttpResponseWriter {
        public void success(PrintWriter var1, KeycloakInstalled var2);

        public void failure(PrintWriter var1, KeycloakInstalled var2);
    }
}

