/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.installed.KeycloakInstalled;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.util.JsonSerialization;

public class KcinitDriver {
    public static final String KC_SESSION_KEY = "KC_SESSION_KEY";
    public static final String KC_LOGIN_CONFIG_PATH = "KC_LOGIN_CONFIG_PATH";
    protected Map<String, String> config;
    protected boolean debug = true;
    protected static byte[] salt = new byte[]{-4, 88, 66, -101, 78, -94, 21, 105};
    String[] args = null;
    protected boolean forceLogin;
    protected boolean browserLogin;
    protected String encryptionKey;
    protected boolean encrypted = false;

    public void mainCmd(String[] args) throws Exception {
        this.args = args;
        if (args.length == 0) {
            this.printHelp();
            return;
        }
        if (args[0].equalsIgnoreCase("token")) {
            this.token();
        } else if (args[0].equalsIgnoreCase("login")) {
            this.login();
        } else if (args[0].equalsIgnoreCase("logout")) {
            this.logout();
        } else if (args[0].equalsIgnoreCase("env")) {
            System.out.println(System.getenv().toString());
        } else if (args[0].equalsIgnoreCase("install")) {
            this.install();
        } else if (args[0].equalsIgnoreCase("uninstall")) {
            this.uninstall();
        } else if (args[0].equalsIgnoreCase("password")) {
            this.passwordKey();
        } else {
            KeycloakInstalled.console().writer().println("Unknown command: " + args[0]);
            KeycloakInstalled.console().writer().println();
            this.printHelp();
        }
    }

    public String getHome() {
        String home = System.getenv("HOME");
        if (home == null && (home = System.getProperty("HOME")) == null) {
            home = Paths.get("", new String[0]).toAbsolutePath().normalize().toString();
        }
        return home;
    }

    public void passwordKey() {
        if (this.args.length < 2) {
            this.printHelp();
            System.exit(1);
        }
        String password = this.args[1];
        try {
            String encodedKey = this.generateEncryptionKey(password);
            System.out.printf(encodedKey, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected String generateEncryptionKey(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100, 128);
        SecretKey tmp = factory.generateSecret(spec);
        byte[] aeskey = tmp.getEncoded();
        return Base64.encodeBytes((byte[])aeskey);
    }

    public JWE createJWE() {
        String key = this.getEncryptionKey();
        if (key == null) {
            throw new RuntimeException("KC_SESSION_KEY env var not set");
        }
        byte[] aesKey = null;
        try {
            aesKey = Base64.decode((byte[])key.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid KC_SESSION_KEYenv var");
        }
        JWE jwe = new JWE();
        SecretKeySpec aesSecret = new SecretKeySpec(aesKey, "AES");
        jwe.getKeyStorage().setDecryptionKey((Key)aesSecret);
        return jwe;
    }

    protected String getEncryptionKey() {
        if (this.encryptionKey != null) {
            return this.encryptionKey;
        }
        return System.getenv(KC_SESSION_KEY);
    }

    public String encrypt(String payload) {
        JWE jwe = this.createJWE();
        JWEHeader jweHeader = new JWEHeader("A128KW", "A128CBC-HS256", null);
        try {
            jwe.header(jweHeader).content(payload.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("cannot encode payload as UTF-8");
        }
        try {
            return jwe.encodeJwe();
        }
        catch (JWEException e) {
            throw new RuntimeException("cannot encrypt payload", e);
        }
    }

    public String decrypt(String encoded) {
        JWE jwe = this.createJWE();
        try {
            jwe.verifyAndDecodeJwe(encoded);
            byte[] content = jwe.getContent();
            if (content == null) {
                return null;
            }
            return new String(content, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot decrypt payload", ex);
        }
    }

    public static String getenv(String name, String defaultValue) {
        String val = System.getenv(name);
        return val == null ? defaultValue : val;
    }

    public File getConfigDirectory() {
        return Paths.get(this.getHome(), KcinitDriver.getenv(KC_LOGIN_CONFIG_PATH, ".keycloak"), "kcinit").toFile();
    }

    public File getConfigFile() {
        return Paths.get(this.getHome(), KcinitDriver.getenv(KC_LOGIN_CONFIG_PATH, ".keycloak"), "kcinit", "config.json").toFile();
    }

    public File getTokenFilePath(String client) {
        return Paths.get(this.getHome(), KcinitDriver.getenv(KC_LOGIN_CONFIG_PATH, ".keycloak"), "kcinit", "tokens", client).toFile();
    }

    public File getTokenDirectory() {
        return Paths.get(this.getHome(), KcinitDriver.getenv(KC_LOGIN_CONFIG_PATH, ".keycloak"), "kcinit", "tokens").toFile();
    }

    protected void checkEnv() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            KeycloakInstalled.console().writer().println("You have not configured kcinit.  Please run 'kcinit install' to configure.");
            System.exit(1);
        }
        byte[] data = new byte[]{};
        try {
            data = this.readFileRaw(configFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (data == null) {
            KeycloakInstalled.console().writer().println("Config file unreadable.  Please run 'kcinit install' to configure.");
            System.exit(1);
        }
        String encodedJwe = null;
        try {
            encodedJwe = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (encodedJwe.contains("realm")) {
            this.encrypted = false;
            return;
        }
        this.encrypted = true;
        if (System.getenv(KC_SESSION_KEY) == null) {
            this.promptLocalPassword();
        }
    }

    protected void promptLocalPassword() {
        String password = KeycloakInstalled.console().passwordPrompt("Enter password to unlock kcinit config files: ", new Object[0]);
        try {
            this.encryptionKey = this.generateEncryptionKey(password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String readFile(File fp) {
        try {
            byte[] data = this.readFileRaw(fp);
            if (data == null) {
                return null;
            }
            String file = new String(data, "UTF-8");
            if (!this.encrypted) {
                return file;
            }
            String decrypted = this.decrypt(file);
            if (decrypted == null) {
                throw new RuntimeException("Unable to decrypt file.  Did you set your local password correctly?");
            }
            return decrypted;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to decrypt file: " + fp.getAbsolutePath() + " Did you set your local password correctly?", e);
        }
    }

    protected byte[] readFileRaw(File fp) throws IOException {
        if (!fp.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(fp);
        byte[] data = new byte[(int)fp.length()];
        fis.read(data);
        fis.close();
        return data;
    }

    protected void writeFile(File fp, String payload) {
        try {
            String data = payload;
            if (this.encrypted) {
                data = this.encrypt(payload);
            }
            FileOutputStream fos = new FileOutputStream(fp);
            fos.write(data.getBytes("UTF-8"));
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void install() {
        if (this.getEncryptionKey() == null) {
            if (KeycloakInstalled.console().confirm("Do you want to protect tokens stored locally with a password? (y/n): ", new Object[0])) {
                String password = "p";
                String confirm = "c";
                do {
                    if ((password = KeycloakInstalled.console().passwordPrompt("Enter local password: ", new Object[0])).equals(confirm = KeycloakInstalled.console().passwordPrompt("Confirm local password: ", new Object[0]))) continue;
                    KeycloakInstalled.console().writer().println();
                    KeycloakInstalled.console().writer().println("Confirmation does not match.  Try again.");
                    KeycloakInstalled.console().writer().println();
                } while (!password.equals(confirm));
                try {
                    this.encrypted = true;
                    this.encryptionKey = this.generateEncryptionKey(password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        } else {
            if (!KeycloakInstalled.console().confirm("KC_SESSION_KEY env var already set.  Do you want to use this as your local encryption key? (y/n): ", new Object[0])) {
                KeycloakInstalled.console().writer().println("Unset KC_SESSION_KEY env var and run again");
                System.exit(1);
            }
            this.encrypted = true;
            this.encryptionKey = this.getEncryptionKey();
        }
        String server = KeycloakInstalled.console().readLine("Authentication server URL [http://localhost:8080/auth]: ", new Object[0]).trim();
        String realm = KeycloakInstalled.console().readLine("Name of realm [master]: ", new Object[0]).trim();
        String client = KeycloakInstalled.console().readLine("CLI client id [kcinit]: ", new Object[0]).trim();
        String secret = KeycloakInstalled.console().readLine("CLI client secret [none]: ", new Object[0]).trim();
        if (server.equals("")) {
            server = "http://localhost:8080/auth";
        }
        if (realm.equals("")) {
            realm = "master";
        }
        if (client.equals("")) {
            client = "kcinit";
        }
        File configDir = this.getTokenDirectory();
        configDir.mkdirs();
        File configFile = this.getConfigFile();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("server", server);
        props.put("realm", realm);
        props.put("client", client);
        props.put("secret", secret);
        try {
            String json = JsonSerialization.writeValueAsString(props);
            this.writeFile(configFile, json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KeycloakInstalled.console().writer().println();
        KeycloakInstalled.console().writer().println("Installation complete!");
        KeycloakInstalled.console().writer().println();
    }

    public void printHelp() {
        KeycloakInstalled.console().writer().println("Commands:");
        KeycloakInstalled.console().writer().println("  login [-f] -f forces login");
        KeycloakInstalled.console().writer().println("  logout");
        KeycloakInstalled.console().writer().println("  token [client] - print access token of desired client.  Defaults to default master client.  Will print either 'error', 'not-allowed',  or 'login-required' on error.");
        KeycloakInstalled.console().writer().println("  install - Install this utility.  Will store in $HOME/.keycloak/kcinit unless KC_LOGIN_CONFIG_PATH env var is set");
        System.exit(1);
    }

    public AdapterConfig getConfig() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            KeycloakInstalled.console().writer().println("You have not configured kcinit.  Please run 'kcinit install' to configure.");
            System.exit(1);
            return null;
        }
        AdapterConfig config = new AdapterConfig();
        config.setAuthServerUrl(this.getConfigProperties().get("server"));
        config.setRealm(this.getConfigProperties().get("realm"));
        config.setResource(this.getConfigProperties().get("client"));
        config.setSslRequired("external");
        String secret = this.getConfigProperties().get("secret");
        if (secret != null && !secret.trim().equals("")) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("secret", secret);
            config.setCredentials(creds);
        } else {
            config.setPublicClient(true);
        }
        return config;
    }

    private Map<String, String> getConfigProperties() {
        if (this.config != null) {
            return this.config;
        }
        if (!this.getConfigFile().exists()) {
            KeycloakInstalled.console().writer().println();
            KeycloakInstalled.console().writer().println("Config file does not exist.  Run kcinit install to set it up.");
            System.exit(1);
        }
        String json = this.readFile(this.getConfigFile());
        try {
            Map map;
            this.config = map = (Map)JsonSerialization.readValue((String)json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.config;
    }

    public String readToken(String client) throws Exception {
        String json = this.getTokenResponse(client);
        if (json == null) {
            return null;
        }
        if (json != null) {
            try {
                AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                if ((long)Time.currentTime() < tokenResponse.getExpiresIn()) {
                    return tokenResponse.getToken();
                }
                AdapterConfig config = this.getConfig();
                KeycloakInstalled installed = new KeycloakInstalled(KeycloakDeploymentBuilder.build((AdapterConfig)config));
                installed.refreshToken(tokenResponse.getRefreshToken());
                this.processResponse(installed, client);
                return tokenResponse.getToken();
            }
            catch (Exception e) {
                File tokenFile = this.getTokenFilePath(client);
                if (tokenFile.exists()) {
                    tokenFile.delete();
                }
                return null;
            }
        }
        return null;
    }

    public String readRefreshToken(String client) throws Exception {
        String json = this.getTokenResponse(client);
        if (json == null) {
            return null;
        }
        if (json != null) {
            try {
                AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                return tokenResponse.getRefreshToken();
            }
            catch (Exception e) {
                File tokenFile;
                if (this.debug) {
                    e.printStackTrace();
                }
                if ((tokenFile = this.getTokenFilePath(client)).exists()) {
                    tokenFile.delete();
                }
                return null;
            }
        }
        return null;
    }

    private String getTokenResponse(String client) throws IOException {
        File tokenFile = this.getTokenFilePath(client);
        try {
            return this.readFile(tokenFile);
        }
        catch (Exception e) {
            if (this.debug) {
                System.err.println("Failed to read encrypted file");
                e.printStackTrace();
            }
            if (tokenFile.exists()) {
                tokenFile.delete();
            }
            return null;
        }
    }

    public void token() throws Exception {
        String json;
        Response response;
        String masterToken;
        String token;
        String masterClient;
        KeycloakInstalled.console().stderrOutput();
        this.checkEnv();
        String client = masterClient = this.getMasterClient();
        if (this.args.length > 1) {
            client = this.args[1];
        }
        if ((token = this.readToken(client)) != null) {
            System.out.print(token);
            return;
        }
        if (token == null && client.equals(masterClient)) {
            this.doConsoleLogin();
            token = this.readToken(client);
            if (token != null) {
                System.out.print(token);
                return;
            }
        }
        if ((masterToken = this.readToken(masterClient)) == null) {
            this.doConsoleLogin();
            masterToken = this.readToken(masterClient);
            if (masterToken == null) {
                System.err.println("Login failed.  Cannot retrieve token");
                System.exit(1);
            }
        }
        Client httpClient = this.getHttpClient();
        WebTarget exchangeUrl = httpClient.target(this.getServer()).path("/realms").path(this.getRealm()).path("protocol/openid-connect/token");
        Form form = new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("client_id", masterClient).param("subject_token", masterToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_token_type", "urn:ietf:params:oauth:token-type:refresh_token").param("audience", client);
        if (this.getMasterClientSecret() != null) {
            form.param("client_secret", this.getMasterClientSecret());
        }
        if ((response = exchangeUrl.request().post(Entity.form((Form)form))).getStatus() == 401 || response.getStatus() == 403) {
            response.close();
            System.err.println("Not allowed to exchange for client token");
            System.exit(1);
        }
        if (response.getStatus() != 200) {
            if (response.getMediaType() != null && response.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                try {
                    json = (String)response.readEntity(String.class);
                    OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)json, OAuth2ErrorRepresentation.class);
                    System.err.println("Failed to exchange token: " + error.getError() + ". " + error.getErrorDescription());
                    System.exit(1);
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
            response.close();
            System.err.println("Unknown error exchanging for client token: " + response.getStatus());
            System.exit(1);
        }
        json = (String)response.readEntity(String.class);
        response.close();
        AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
        if (tokenResponse.getToken() != null) {
            this.getTokenDirectory().mkdirs();
            tokenResponse.setExpiresIn((long)Time.currentTime() + tokenResponse.getExpiresIn());
            tokenResponse.setIdToken(null);
            json = JsonSerialization.writeValueAsString((Object)tokenResponse);
            this.writeFile(this.getTokenFilePath(client), json);
            System.out.printf(tokenResponse.getToken(), new Object[0]);
        } else {
            System.err.println("Error processing token");
            System.exit(1);
        }
    }

    protected String getMasterClientSecret() {
        return this.getProperty("secret");
    }

    protected String getServer() {
        return this.getProperty("server");
    }

    protected String getRealm() {
        return this.getProperty("realm");
    }

    public String getProperty(String name) {
        return this.getConfigProperties().get(name);
    }

    protected boolean forceLogin() {
        return this.args.length > 0 && this.args[0].equals("-f");
    }

    public Client getHttpClient() {
        return new ResteasyClientBuilder().disableTrustManager().build();
    }

    public void login() throws Exception {
        this.checkEnv();
        for (String arg : this.args = Arrays.copyOfRange(this.args, 1, this.args.length)) {
            if (arg.equals("-f") || arg.equals("-force")) {
                this.forceLogin = true;
                this.args = Arrays.copyOfRange(this.args, 1, this.args.length);
                continue;
            }
            if (arg.equals("-browser") || arg.equals("-b")) {
                this.browserLogin = true;
                this.args = Arrays.copyOfRange(this.args, 1, this.args.length);
                continue;
            }
            System.err.println("Illegal argument: " + arg);
            this.printHelp();
            System.exit(1);
        }
        String masterClient = this.getMasterClient();
        if (!this.forceLogin && this.readToken(masterClient) != null) {
            KeycloakInstalled.console().writer().println("Already logged in.  `kcinit -f` to force relogin");
            return;
        }
        this.doConsoleLogin();
        KeycloakInstalled.console().writer().println("Login successful!");
    }

    public void doConsoleLogin() throws Exception {
        String masterClient = this.getMasterClient();
        AdapterConfig config = this.getConfig();
        KeycloakInstalled installed = new KeycloakInstalled(KeycloakDeploymentBuilder.build((AdapterConfig)config));
        if (!installed.loginCommandLine()) {
            System.exit(1);
        }
        this.processResponse(installed, masterClient);
    }

    private String getMasterClient() {
        return this.getProperty("client");
    }

    private void processResponse(KeycloakInstalled installed, String client) throws IOException {
        AccessTokenResponse tokenResponse = installed.getTokenResponse();
        tokenResponse.setExpiresIn((long)Time.currentTime() + tokenResponse.getExpiresIn());
        tokenResponse.setIdToken(null);
        String json = JsonSerialization.writeValueAsString((Object)tokenResponse);
        this.getTokenDirectory().mkdirs();
        this.writeFile(this.getTokenFilePath(client), json);
    }

    public void logout() throws Exception {
        block5: {
            String token = this.readRefreshToken(this.getMasterClient());
            if (token != null) {
                try {
                    KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.getConfig());
                    ServerRequest.invokeLogout((KeycloakDeployment)deployment, (String)token);
                }
                catch (Exception e) {
                    if (!this.debug) break block5;
                    e.printStackTrace();
                }
            }
        }
        if (this.getTokenDirectory().exists()) {
            for (File fp : this.getTokenDirectory().listFiles()) {
                fp.delete();
            }
        }
    }

    public void uninstall() throws Exception {
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            configFile.delete();
        }
        if (this.getTokenDirectory().exists()) {
            for (File fp : this.getTokenDirectory().listFiles()) {
                fp.delete();
            }
        }
    }
}

