/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.entities.CachedApplication;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedOAuthClient;
import org.keycloak.models.cache.entities.CachedRealmRole;

public class CachedRealm {
    private String id;
    private String name;
    private boolean enabled;
    private boolean sslNotRequired;
    private boolean registrationAllowed;
    private boolean rememberMe;
    private boolean verifyEmail;
    private boolean passwordCredentialGrantAllowed;
    private boolean resetPasswordAllowed;
    private boolean social;
    private boolean updateProfileOnInitialSocialLogin;
    private boolean bruteForceProtected;
    private int maxFailureWaitSeconds;
    private int minimumQuickLoginWaitSeconds;
    private int waitIncrementSeconds;
    private long quickLoginCheckMilliSeconds;
    private int maxDeltaTimeSeconds;
    private int failureFactor;
    private int ssoSessionIdleTimeout;
    private int ssoSessionMaxLifespan;
    private int accessTokenLifespan;
    private int accessCodeLifespan;
    private int accessCodeLifespanUserAction;
    private int notBefore;
    private PasswordPolicy passwordPolicy;
    private String publicKeyPem;
    private String privateKeyPem;
    private String loginTheme;
    private String accountTheme;
    private String adminTheme;
    private String emailTheme;
    private String masterAdminApp;
    private List<RequiredCredentialModel> requiredCredentials = new ArrayList<RequiredCredentialModel>();
    private List<AuthenticationProviderModel> authenticationProviders = new ArrayList<AuthenticationProviderModel>();
    private Map<String, String> smtpConfig = new HashMap<String, String>();
    private Map<String, String> socialConfig = new HashMap<String, String>();
    private Map<String, String> ldapServerConfig = new HashMap<String, String>();
    private boolean auditEnabled;
    private long auditExpiration;
    private Set<String> auditListeners = new HashSet<String>();
    private List<String> defaultRoles = new LinkedList<String>();
    private Map<String, String> realmRoles = new HashMap<String, String>();
    private Set<String> rolesById = new HashSet<String>();
    private Map<String, String> applications = new HashMap<String, String>();
    private Map<String, String> clients = new HashMap<String, String>();

    public CachedRealm() {
    }

    public CachedRealm(KeycloakCache cache, KeycloakSession delegate, RealmModel model) {
        CachedClient cachedApp;
        this.id = model.getId();
        this.name = model.getName();
        this.enabled = model.isEnabled();
        this.sslNotRequired = model.isSslNotRequired();
        this.registrationAllowed = model.isRegistrationAllowed();
        this.rememberMe = model.isRememberMe();
        this.verifyEmail = model.isVerifyEmail();
        this.passwordCredentialGrantAllowed = model.isPasswordCredentialGrantAllowed();
        this.resetPasswordAllowed = model.isResetPasswordAllowed();
        this.social = model.isSocial();
        this.updateProfileOnInitialSocialLogin = model.isUpdateProfileOnInitialSocialLogin();
        this.bruteForceProtected = model.isBruteForceProtected();
        this.maxFailureWaitSeconds = model.getMaxFailureWaitSeconds();
        this.minimumQuickLoginWaitSeconds = model.getMinimumQuickLoginWaitSeconds();
        this.waitIncrementSeconds = model.getWaitIncrementSeconds();
        this.quickLoginCheckMilliSeconds = model.getQuickLoginCheckMilliSeconds();
        this.maxDeltaTimeSeconds = model.getMaxDeltaTimeSeconds();
        this.failureFactor = model.getFailureFactor();
        this.ssoSessionIdleTimeout = model.getSsoSessionIdleTimeout();
        this.ssoSessionMaxLifespan = model.getSsoSessionMaxLifespan();
        this.accessTokenLifespan = model.getAccessTokenLifespan();
        this.accessCodeLifespan = model.getAccessCodeLifespan();
        this.accessCodeLifespanUserAction = model.getAccessCodeLifespanUserAction();
        this.notBefore = model.getNotBefore();
        this.passwordPolicy = model.getPasswordPolicy();
        this.publicKeyPem = model.getPublicKeyPem();
        this.privateKeyPem = model.getPrivateKeyPem();
        this.loginTheme = model.getLoginTheme();
        this.accountTheme = model.getAccountTheme();
        this.adminTheme = model.getAdminTheme();
        this.emailTheme = model.getEmailTheme();
        this.requiredCredentials = model.getRequiredCredentials();
        this.authenticationProviders = model.getAuthenticationProviders();
        this.smtpConfig.putAll(model.getSmtpConfig());
        this.socialConfig.putAll(model.getSocialConfig());
        this.ldapServerConfig.putAll(model.getLdapServerConfig());
        this.auditEnabled = model.isAuditEnabled();
        this.auditExpiration = model.getAuditExpiration();
        this.auditListeners.addAll(model.getAuditListeners());
        this.defaultRoles.addAll(model.getDefaultRoles());
        this.masterAdminApp = model.getMasterAdminApp().getId();
        for (RoleModel role : model.getRoles()) {
            this.realmRoles.put(role.getName(), role.getId());
            this.rolesById.add(role.getId());
            CachedRealmRole cachedRole = new CachedRealmRole(role);
            cache.addCachedRole(cachedRole);
        }
        for (ApplicationModel app : model.getApplications()) {
            this.applications.put(app.getName(), app.getId());
            cachedApp = new CachedApplication(cache, delegate, model, app);
            cache.addCachedApplication((CachedApplication)cachedApp);
            for (String roleId : cachedApp.getRoles().values()) {
                this.rolesById.add(roleId);
            }
        }
        for (OAuthClientModel client : model.getOAuthClients()) {
            this.clients.put(client.getClientId(), client.getId());
            cachedApp = new CachedOAuthClient(cache, delegate, model, client);
            cache.addCachedOAuthClient((CachedOAuthClient)cachedApp);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getMasterAdminApp() {
        return this.masterAdminApp;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public Map<String, String> getRealmRoles() {
        return this.realmRoles;
    }

    public Set<String> getRolesById() {
        return this.rolesById;
    }

    public Map<String, String> getApplications() {
        return this.applications;
    }

    public Map<String, String> getClients() {
        return this.clients;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSslNotRequired() {
        return this.sslNotRequired;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.passwordCredentialGrantAllowed;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public boolean isBruteForceProtected() {
        return this.bruteForceProtected;
    }

    public int getMaxFailureWaitSeconds() {
        return this.maxFailureWaitSeconds;
    }

    public int getWaitIncrementSeconds() {
        return this.waitIncrementSeconds;
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.minimumQuickLoginWaitSeconds;
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.quickLoginCheckMilliSeconds;
    }

    public int getMaxDeltaTimeSeconds() {
        return this.maxDeltaTimeSeconds;
    }

    public int getFailureFactor() {
        return this.failureFactor;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public int getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public int getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public int getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public int getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public int getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public boolean isSocial() {
        return this.social;
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.updateProfileOnInitialSocialLogin;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public Map<String, String> getSocialConfig() {
        return this.socialConfig;
    }

    public Map<String, String> getLdapServerConfig() {
        return this.ldapServerConfig;
    }

    public List<AuthenticationProviderModel> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    public long getAuditExpiration() {
        return this.auditExpiration;
    }

    public Set<String> getAuditListeners() {
        return this.auditListeners;
    }
}

