/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.ApplicationAdapter;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.OAuthClientAdapter;
import org.keycloak.models.cache.RealmAdapter;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.RoleAdapter;
import org.keycloak.models.cache.entities.CachedApplication;
import org.keycloak.models.cache.entities.CachedApplicationRole;
import org.keycloak.models.cache.entities.CachedOAuthClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRealmRole;
import org.keycloak.models.cache.entities.CachedRole;

public class DefaultCacheRealmProvider
implements CacheRealmProvider {
    protected RealmCache cache;
    protected KeycloakSession session;
    protected RealmProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Set<String> appInvalidations = new HashSet<String>();
    protected Set<String> roleInvalidations = new HashSet<String>();
    protected Set<String> clientInvalidations = new HashSet<String>();
    protected Set<String> userInvalidations = new HashSet<String>();
    protected Map<String, RealmModel> managedRealms = new HashMap<String, RealmModel>();
    protected Map<String, ApplicationModel> managedApplications = new HashMap<String, ApplicationModel>();
    protected Map<String, OAuthClientModel> managedClients = new HashMap<String, OAuthClientModel>();
    protected Map<String, RoleModel> managedRoles = new HashMap<String, RoleModel>();
    protected boolean clearAll;

    public DefaultCacheRealmProvider(RealmCache cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        session.getTransaction().enlistAfterCompletion(this.getTransaction());
    }

    @Override
    public boolean isEnabled() {
        return this.cache.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
    }

    @Override
    public RealmProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (RealmProvider)this.session.getProvider(RealmProvider.class);
        return this.delegate;
    }

    @Override
    public void registerRealmInvalidation(String id) {
        this.realmInvalidations.add(id);
    }

    @Override
    public void registerApplicationInvalidation(String id) {
        this.appInvalidations.add(id);
    }

    @Override
    public void registerRoleInvalidation(String id) {
        this.roleInvalidations.add(id);
    }

    @Override
    public void registerOAuthClientInvalidation(String id) {
        this.clientInvalidations.add(id);
    }

    @Override
    public void registerUserInvalidation(String id) {
        this.userInvalidations.add(id);
    }

    protected void runInvalidations() {
        for (String id : this.realmInvalidations) {
            this.cache.invalidateCachedRealmById(id);
        }
        for (String id : this.roleInvalidations) {
            this.cache.invalidateRoleById(id);
        }
        for (String id : this.appInvalidations) {
            this.cache.invalidateCachedApplicationById(id);
        }
        for (String id : this.clientInvalidations) {
            this.cache.invalidateCachedOAuthClientById(id);
        }
    }

    private KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                DefaultCacheRealmProvider.this.transactionActive = true;
            }

            public void commit() {
                if (DefaultCacheRealmProvider.this.delegate == null) {
                    return;
                }
                if (DefaultCacheRealmProvider.this.clearAll) {
                    DefaultCacheRealmProvider.this.cache.clear();
                }
                DefaultCacheRealmProvider.this.runInvalidations();
                DefaultCacheRealmProvider.this.transactionActive = false;
            }

            public void rollback() {
                DefaultCacheRealmProvider.this.setRollbackOnly = true;
                DefaultCacheRealmProvider.this.runInvalidations();
                DefaultCacheRealmProvider.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                DefaultCacheRealmProvider.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return DefaultCacheRealmProvider.this.setRollbackOnly;
            }

            public boolean isActive() {
                return DefaultCacheRealmProvider.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        RealmModel realm = this.getDelegate().createRealm(name);
        if (!this.cache.isEnabled()) {
            return realm;
        }
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel createRealm(String id, String name) {
        RealmModel realm = this.getDelegate().createRealm(id, name);
        if (!this.cache.isEnabled()) {
            return realm;
        }
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel getRealm(String id) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRealm(id);
        }
        CachedRealm cached = this.cache.getCachedRealm(id);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealm(id);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedRealm(this.cache, this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(id)) {
                return this.getDelegate().getRealm(id);
            }
            if (this.managedRealms.containsKey(id)) {
                return this.managedRealms.get(id);
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(id, adapter);
        return adapter;
    }

    public RealmModel getRealmByName(String name) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRealmByName(name);
        }
        CachedRealm cached = this.cache.getCachedRealmByName(name);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealmByName(name);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(model.getId())) {
                return model;
            }
            cached = new CachedRealm(this.cache, this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(cached.getId())) {
                return this.getDelegate().getRealmByName(name);
            }
            if (this.managedRealms.containsKey(cached.getId())) {
                return this.managedRealms.get(cached.getId());
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(cached.getId(), adapter);
        return adapter;
    }

    public List<RealmModel> getRealms() {
        return this.getDelegate().getRealms();
    }

    public boolean removeRealm(String id) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().removeRealm(id);
        }
        this.cache.invalidateCachedRealmById(id);
        RealmModel realm = this.getDelegate().getRealm(id);
        Set realmRoles = null;
        if (realm != null) {
            realmRoles = realm.getRoles();
        }
        boolean didIt = this.getDelegate().removeRealm(id);
        this.realmInvalidations.add(id);
        if (didIt && realmRoles != null) {
            for (RoleModel role : realmRoles) {
                this.roleInvalidations.add(role.getId());
            }
        }
        return didIt;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRoleById(id, realm);
        }
        CachedRole cached = this.cache.getRole(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            RoleModel model = this.getDelegate().getRoleById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.roleInvalidations.contains(id)) {
                return model;
            }
            cached = model.getContainer() instanceof ApplicationModel ? new CachedApplicationRole(((ApplicationModel)model.getContainer()).getId(), model, realm) : new CachedRealmRole(model, realm);
            this.cache.addCachedRole(cached);
        } else {
            if (this.roleInvalidations.contains(id)) {
                return this.getDelegate().getRoleById(id, realm);
            }
            if (this.managedRoles.containsKey(id)) {
                return this.managedRoles.get(id);
            }
        }
        RoleAdapter adapter = new RoleAdapter(cached, this.cache, this, realm);
        this.managedRoles.put(id, adapter);
        return adapter;
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getApplicationById(id, realm);
        }
        CachedApplication cached = this.cache.getApplication(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            ApplicationModel model = this.getDelegate().getApplicationById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.appInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedApplication(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedApplication(cached);
        } else {
            if (this.appInvalidations.contains(id)) {
                return this.getDelegate().getApplicationById(id, realm);
            }
            if (this.managedApplications.containsKey(id)) {
                return this.managedApplications.get(id);
            }
        }
        ApplicationAdapter adapter = new ApplicationAdapter(realm, cached, this, this.cache);
        this.managedApplications.put(id, adapter);
        return adapter;
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getOAuthClientById(id, realm);
        }
        CachedOAuthClient cached = this.cache.getOAuthClient(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            OAuthClientModel model = this.getDelegate().getOAuthClientById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.clientInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedOAuthClient(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedOAuthClient(cached);
        } else {
            if (this.clientInvalidations.contains(id)) {
                return this.getDelegate().getOAuthClientById(id, realm);
            }
            if (this.managedClients.containsKey(id)) {
                return this.managedClients.get(id);
            }
        }
        OAuthClientAdapter adapter = new OAuthClientAdapter(realm, cached, this, this.cache);
        this.managedClients.put(id, adapter);
        return adapter;
    }
}

