/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientIdentityProviderMappingModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.RealmCache;

public class CachedClient {
    protected String id;
    protected String name;
    protected String realm;
    protected Set<String> redirectUris = new HashSet<String>();
    protected boolean enabled;
    protected String secret;
    protected String protocol;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected boolean publicClient;
    protected boolean fullScopeAllowed;
    protected boolean directGrantsOnly;
    protected boolean frontchannelLogout;
    protected int notBefore;
    protected Set<String> scope = new HashSet<String>();
    protected Set<String> webOrigins = new HashSet<String>();
    private List<ClientIdentityProviderMappingModel> identityProviders = new ArrayList<ClientIdentityProviderMappingModel>();
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();

    public CachedClient(RealmCache cache, RealmProvider delegate, RealmModel realm, ClientModel model) {
        this.id = model.getId();
        this.secret = model.getSecret();
        this.name = model.getClientId();
        this.realm = realm.getId();
        this.enabled = model.isEnabled();
        this.protocol = model.getProtocol();
        this.attributes.putAll(model.getAttributes());
        this.notBefore = model.getNotBefore();
        this.directGrantsOnly = model.isDirectGrantsOnly();
        this.frontchannelLogout = model.isFrontchannelLogout();
        this.publicClient = model.isPublicClient();
        this.fullScopeAllowed = model.isFullScopeAllowed();
        this.redirectUris.addAll(model.getRedirectUris());
        this.webOrigins.addAll(model.getWebOrigins());
        for (RoleModel role : model.getScopeMappings()) {
            this.scope.add(role.getId());
        }
        this.identityProviders = model.getIdentityProviders();
        for (ProtocolMapperModel mapper : model.getProtocolMappers()) {
            this.protocolMappers.add(mapper);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public boolean isDirectGrantsOnly() {
        return this.directGrantsOnly;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isFrontchannelLogout() {
        return this.frontchannelLogout;
    }

    public List<ClientIdentityProviderMappingModel> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean hasIdentityProvider(String providerId) {
        for (ClientIdentityProviderMappingModel model : this.getIdentityProviders()) {
            if (!model.getIdentityProvider().equals(providerId)) continue;
            return true;
        }
        return false;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public boolean isAllowedRetrieveTokenFromIdentityProvider(String providerId) {
        for (ClientIdentityProviderMappingModel model : this.getIdentityProviders()) {
            if (!model.getIdentityProvider().equals(providerId)) continue;
            return model.isRetrieveToken();
        }
        return false;
    }
}

