/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.cache.RealmCache;

public class CachedClientTemplate
implements Serializable {
    private String id;
    private String name;
    private String description;
    private String realm;
    private String protocol;
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();

    public CachedClientTemplate(RealmCache cache, RealmProvider delegate, RealmModel realm, ClientTemplateModel model) {
        this.id = model.getId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.realm = realm.getId();
        this.protocol = model.getProtocol();
        for (ProtocolMapperModel mapper : model.getProtocolMappers()) {
            this.protocolMappers.add(mapper);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRealm() {
        return this.realm;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

