/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.RSATokenVerifier;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.VerificationException;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.representations.SkeletonKeyToken;

@Priority(value=1000)
public class JaxrsBearerTokenFilter
implements ContainerRequestFilter {
    protected ResourceMetadata resourceMetadata;
    private static Logger log = Logger.getLogger(JaxrsBearerTokenFilter.class);
    @Context
    protected SecurityContext securityContext;

    public JaxrsBearerTokenFilter(ResourceMetadata resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
    }

    protected void challengeResponse(ContainerRequestContext request, String error, String description) {
        StringBuilder header = new StringBuilder("Bearer realm=\"");
        header.append(this.resourceMetadata.getRealm()).append("\"");
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        request.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)header.toString()).build());
    }

    public void filter(ContainerRequestContext request) throws IOException {
        String authHeader = request.getHeaderString("Authorization");
        if (authHeader == null) {
            this.challengeResponse(request, null, null);
            return;
        }
        String[] split = authHeader.trim().split("\\s+");
        if (split == null || split.length != 2) {
            this.challengeResponse(request, null, null);
        }
        if (!split[0].equalsIgnoreCase("Bearer")) {
            this.challengeResponse(request, null, null);
        }
        String tokenString = split[1];
        try {
            SkeletonKeyToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.resourceMetadata.getRealmKey(), (String)this.resourceMetadata.getRealm());
            SkeletonKeySession skSession = new SkeletonKeySession(tokenString, token, this.resourceMetadata);
            ResteasyProviderFactory.pushContext(SkeletonKeySession.class, (Object)skSession);
            String callerPrincipal = this.securityContext.getUserPrincipal() != null ? this.securityContext.getUserPrincipal().getName() : null;
            final SkeletonKeyPrincipal principal = new SkeletonKeyPrincipal(token.getSubject(), callerPrincipal);
            final boolean isSecure = this.securityContext.isSecure();
            final SkeletonKeyToken.Access access = this.resourceMetadata.getResourceName() != null ? token.getResourceAccess(this.resourceMetadata.getResourceName()) : token.getRealmAccess();
            SecurityContext ctx = new SecurityContext(){

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String role) {
                    if (access.getRoles() == null) {
                        return false;
                    }
                    return access.getRoles().contains(role);
                }

                public boolean isSecure() {
                    return isSecure;
                }

                public String getAuthenticationScheme() {
                    return "OAUTH_BEARER";
                }
            };
            request.setSecurityContext(ctx);
        }
        catch (VerificationException e) {
            log.error("Failed to verify token", (Throwable)e);
            this.challengeResponse(request, "invalid_token", e.getMessage());
        }
    }
}

