/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.PreMatching;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.jaxrs.JaxrsBearerTokenFilterImpl;
import org.osgi.framework.BundleContext;

@PreMatching
@Priority(value=1000)
@Deprecated
public class OsgiJaxrsBearerTokenFilterImpl
extends JaxrsBearerTokenFilterImpl {
    private static final Logger log = Logger.getLogger("" + JaxrsBearerTokenFilterImpl.class);
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.attemptStart();
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.bundleContext != null;
    }

    @Override
    protected Class<? extends KeycloakConfigResolver> loadResolverClass() {
        String resolverClass = this.getKeycloakConfigResolverClass();
        try {
            return this.bundleContext.getBundle().loadClass(resolverClass);
        }
        catch (ClassNotFoundException cnfe) {
            log.warning("Not able to find class from bundleContext. Fallback to current classloader");
            return super.loadResolverClass();
        }
    }

    @Override
    protected InputStream loadKeycloakConfigFile() {
        String keycloakConfigFile = this.getKeycloakConfigFile();
        if (keycloakConfigFile.startsWith("classpath:")) {
            String classPathLocation = keycloakConfigFile.replace("classpath:", "");
            log.fine("Loading config from classpath on location: " + classPathLocation);
            URL cfgUrl = this.bundleContext.getBundle().getResource(classPathLocation);
            if (cfgUrl == null) {
                log.warning("Not able to find configFile from bundleContext. Fallback to current classloader");
                return super.loadKeycloakConfigFile();
            }
            try {
                return cfgUrl.openStream();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return super.loadKeycloakConfigFile();
    }
}

