/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.security.cert.X509Certificate;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.HostUtils;

public class JaxrsHttpFacade
implements OIDCHttpFacade {
    protected final ContainerRequestContext requestContext;
    protected final SecurityContext securityContext;
    protected final RequestFacade requestFacade = new RequestFacade();
    protected final ResponseFacade responseFacade = new ResponseFacade();
    protected KeycloakSecurityContext keycloakSecurityContext;
    protected boolean responseFinished;

    public JaxrsHttpFacade(ContainerRequestContext containerRequestContext, SecurityContext securityContext) {
        this.requestContext = containerRequestContext;
        this.securityContext = securityContext;
    }

    public KeycloakSecurityContext getSecurityContext() {
        return this.keycloakSecurityContext;
    }

    public void setSecurityContext(KeycloakSecurityContext securityContext) {
        this.keycloakSecurityContext = securityContext;
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    public boolean isResponseFinished() {
        return this.responseFinished;
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        private Response.ResponseBuilder responseBuilder = Response.status((int)204);

        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            this.responseBuilder.status(status);
        }

        public void addHeader(String name, String value) {
            this.responseBuilder.header(name, (Object)value);
        }

        public void setHeader(String name, String value) {
            this.responseBuilder.header(name, (Object)value);
        }

        public void resetCookie(String name, String path) {
            throw new IllegalStateException("Not supported yet");
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            throw new IllegalStateException("Not supported yet");
        }

        public OutputStream getOutputStream() {
            throw new IllegalStateException("Not supported yet");
        }

        public void sendError(int code) {
            Response response = this.responseBuilder.status(code).build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }

        public void sendError(int code, String message) {
            Response response = this.responseBuilder.status(code).entity((Object)message).build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }

        public void end() {
            Response response = this.responseBuilder.build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        protected RequestFacade() {
        }

        public String getFirstParam(String param) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public String getMethod() {
            return JaxrsHttpFacade.this.requestContext.getMethod();
        }

        public String getURI() {
            return JaxrsHttpFacade.this.requestContext.getUriInfo().getRequestUri().toString();
        }

        public String getRelativePath() {
            return JaxrsHttpFacade.this.requestContext.getUriInfo().getPath();
        }

        public boolean isSecure() {
            return JaxrsHttpFacade.this.securityContext.isSecure();
        }

        public String getQueryParamValue(String param) {
            MultivaluedMap queryParams = JaxrsHttpFacade.this.requestContext.getUriInfo().getQueryParameters();
            if (queryParams == null) {
                return null;
            }
            return (String)queryParams.getFirst((Object)param);
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            Map cookies = JaxrsHttpFacade.this.requestContext.getCookies();
            if (cookies == null) {
                return null;
            }
            Cookie cookie = (Cookie)cookies.get(cookieName);
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public String getHeader(String name) {
            return JaxrsHttpFacade.this.requestContext.getHeaderString(name);
        }

        public List<String> getHeaders(String name) {
            MultivaluedMap headers = JaxrsHttpFacade.this.requestContext.getHeaders();
            return headers == null ? null : (List)headers.get((Object)name);
        }

        public InputStream getInputStream() {
            return JaxrsHttpFacade.this.requestContext.getEntityStream();
        }

        public String getRemoteAddr() {
            return HostUtils.getIpAddress();
        }

        public void setError(AuthenticationError error) {
            JaxrsHttpFacade.this.requestContext.setProperty(AuthenticationError.class.getName(), (Object)error);
        }

        public void setError(LogoutError error) {
            JaxrsHttpFacade.this.requestContext.setProperty(LogoutError.class.getName(), (Object)error);
        }
    }
}

