/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.UriUtils;

public class JettyHttpFacade
implements HttpFacade {
    public static final String __J_METHOD = "org.eclipse.jetty.security.HTTP_METHOD";
    protected Request request;
    protected HttpServletResponse response;
    protected RequestFacade requestFacade = new RequestFacade();
    protected ResponseFacade responseFacade = new ResponseFacade();
    protected MultivaluedHashMap<String, String> queryParameters;

    public JettyHttpFacade(Request request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    public boolean isEnded() {
        return this.responseFacade.isEnded();
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        protected boolean ended;

        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            JettyHttpFacade.this.response.setStatus(status);
        }

        public void addHeader(String name, String value) {
            JettyHttpFacade.this.response.addHeader(name, value);
        }

        public void setHeader(String name, String value) {
            JettyHttpFacade.this.response.setHeader(name, value);
        }

        public void resetCookie(String name, String path) {
            this.setCookie(name, "", null, path, 0, false, false);
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            Cookie cookie = new Cookie(name, value);
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (path != null) {
                cookie.setPath(path);
            }
            if (secure) {
                cookie.setSecure(true);
            }
            if (httpOnly) {
                cookie.setHttpOnly(httpOnly);
            }
            cookie.setMaxAge(maxAge);
            JettyHttpFacade.this.response.addCookie(cookie);
        }

        public OutputStream getOutputStream() {
            try {
                return JettyHttpFacade.this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void sendError(int code, String message) {
            try {
                JettyHttpFacade.this.response.sendError(code, message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void end() {
            this.ended = true;
        }

        public boolean isEnded() {
            return this.ended;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        protected RequestFacade() {
        }

        public String getURI() {
            StringBuffer buf = JettyHttpFacade.this.request.getRequestURL();
            if (JettyHttpFacade.this.request.getQueryString() != null) {
                buf.append('?').append(JettyHttpFacade.this.request.getQueryString());
            }
            return buf.toString();
        }

        public String getFirstParam(String param) {
            return JettyHttpFacade.this.request.getParameter(param);
        }

        public boolean isSecure() {
            return JettyHttpFacade.this.request.isSecure();
        }

        public String getQueryParamValue(String paramName) {
            if (JettyHttpFacade.this.queryParameters == null) {
                JettyHttpFacade.this.queryParameters = UriUtils.decodeQueryString((String)JettyHttpFacade.this.request.getQueryString());
            }
            return (String)JettyHttpFacade.this.queryParameters.getFirst((Object)paramName);
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            if (JettyHttpFacade.this.request.getCookies() == null) {
                return null;
            }
            Cookie cookie = null;
            for (Cookie c : JettyHttpFacade.this.request.getCookies()) {
                if (!c.getName().equals(cookieName)) continue;
                cookie = c;
                break;
            }
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public List<String> getHeaders(String name) {
            Enumeration headers = JettyHttpFacade.this.request.getHeaders(name);
            if (headers == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                list.add((String)headers.nextElement());
            }
            return list;
        }

        public InputStream getInputStream() {
            try {
                return JettyHttpFacade.this.request.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getMethod() {
            return JettyHttpFacade.this.request.getMethod();
        }

        public String getHeader(String name) {
            return JettyHttpFacade.this.request.getHeader(name);
        }

        public String getRemoteAddr() {
            return JettyHttpFacade.this.request.getRemoteAddr();
        }
    }
}

