/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;

public class LDAPUtils {
    public static User addUser(PartitionManager partitionManager, String username, String firstName, String lastName, String email) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        User picketlinkUser = new User(username);
        picketlinkUser.setFirstName(firstName);
        picketlinkUser.setLastName(lastName);
        picketlinkUser.setEmail(email);
        picketlinkUser.setAttribute(new Attribute("fullName", (Serializable)((Object)LDAPUtils.getFullName(username, firstName, lastName))));
        idmManager.add((IdentityType)picketlinkUser);
        return picketlinkUser;
    }

    public static User updateUser(PartitionManager partitionManager, String username, String firstName, String lastName, String email) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        User picketlinkUser = BasicModel.getUser((IdentityManager)idmManager, (String)username);
        picketlinkUser.setFirstName(firstName);
        picketlinkUser.setLastName(lastName);
        picketlinkUser.setEmail(email);
        picketlinkUser.setAttribute(new Attribute("fullName", (Serializable)((Object)LDAPUtils.getFullName(username, firstName, lastName))));
        idmManager.update((IdentityType)picketlinkUser);
        return picketlinkUser;
    }

    public static void updatePassword(PartitionManager partitionManager, User picketlinkUser, String password) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        idmManager.updateCredential((Account)picketlinkUser, (Object)new Password(password.toCharArray()));
    }

    public static boolean validatePassword(PartitionManager partitionManager, String username, String password) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(username);
        credential.setPassword(new Password(password.toCharArray()));
        idmManager.validateCredentials((Credentials)credential);
        return credential.getStatus() == Credentials.Status.VALID;
    }

    public static User getUser(PartitionManager partitionManager, String username) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        return BasicModel.getUser((IdentityManager)idmManager, (String)username);
    }

    public static boolean removeUser(PartitionManager partitionManager, String username) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        User picketlinkUser = BasicModel.getUser((IdentityManager)idmManager, (String)username);
        if (picketlinkUser == null) {
            return false;
        }
        idmManager.remove((IdentityType)picketlinkUser);
        return true;
    }

    public static void removeAllUsers(PartitionManager partitionManager) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        List users = idmManager.createIdentityQuery(User.class).getResultList();
        for (User user : users) {
            idmManager.remove((IdentityType)user);
        }
    }

    public static List<User> getAllUsers(PartitionManager partitionManager) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        return idmManager.createIdentityQuery(User.class).getResultList();
    }

    private static IdentityManager getIdentityManager(PartitionManager partitionManager) {
        return partitionManager.createIdentityManager();
    }

    private static String getFullName(String username, String firstName, String lastName) {
        String fullName = firstName != null && lastName != null ? firstName + " " + lastName : (firstName != null && firstName.trim().length() > 0 ? firstName : lastName);
        if (fullName == null || fullName.trim().length() == 0) {
            fullName = username;
        }
        return fullName;
    }
}

