/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.UserAttributeLDAPFederationMapper;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.mappers.UserFederationMapper;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "user-attribute-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "Used to map single attribute from LDAP user to attribute of UserModel in Keycloak DB";
    }

    public String getDisplayCategory() {
        return "Attribute Mapper";
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfig(UserFederationMapperModel mapperModel) throws MapperConfigValidationException {
        this.checkMandatoryConfigAttribute("user.model.attribute", "User Model Attribute", mapperModel);
        this.checkMandatoryConfigAttribute("ldap.attribute", "LDAP Attribute", mapperModel);
    }

    public UserFederationMapper create(KeycloakSession session) {
        return new UserAttributeLDAPFederationMapper();
    }

    static {
        ProviderConfigProperty userModelAttribute = UserAttributeLDAPFederationMapperFactory.createConfigProperty("user.model.attribute", "User Model Attribute", "Name of mapped UserModel property or UserModel attribute in Keycloak DB. For example 'firstName', 'lastName, 'email', 'street' etc.", "String", null);
        configProperties.add(userModelAttribute);
        ProviderConfigProperty ldapAttribute = UserAttributeLDAPFederationMapperFactory.createConfigProperty("ldap.attribute", "LDAP Attribute", "Name of mapped attribute on LDAP object. For example 'cn', 'sn, 'mail', 'street' etc.", "String", null);
        configProperties.add(ldapAttribute);
        ProviderConfigProperty readOnly = UserAttributeLDAPFederationMapperFactory.createConfigProperty("read.only", "Read Only", "Read-only attribute is imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.", "boolean", "false");
        configProperties.add(readOnly);
    }
}

