/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.store.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.idm.model.LDAPDn;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.BetweenCondition;
import org.keycloak.federation.ldap.idm.query.internal.EqualCondition;
import org.keycloak.federation.ldap.idm.query.internal.GreaterThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.InCondition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.idm.query.internal.LessThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.OrCondition;
import org.keycloak.federation.ldap.idm.store.IdentityStore;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPOperationManager;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPUtil;
import org.keycloak.models.ModelException;

public class LDAPIdentityStore
implements IdentityStore {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStore.class);
    private final LDAPConfig config;
    private final LDAPOperationManager operationManager;

    public LDAPIdentityStore(LDAPConfig config) {
        this.config = config;
        try {
            this.operationManager = new LDAPOperationManager(config);
        }
        catch (NamingException e) {
            throw new ModelException("Couldn't init operation manager", (Throwable)e);
        }
    }

    @Override
    public LDAPConfig getConfig() {
        return this.config;
    }

    @Override
    public void add(LDAPObject ldapObject) {
        if (ldapObject.getUuid() != null) {
            throw new ModelException("Can't add object with already assigned uuid");
        }
        String entryDN = ldapObject.getDn().toString();
        BasicAttributes ldapAttributes = this.extractAttributes(ldapObject, true);
        this.operationManager.createSubContext(entryDN, ldapAttributes);
        ldapObject.setUuid(this.getEntryIdentifier(ldapObject));
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] and dn [%s] successfully added to LDAP store.", (Object)ldapObject.getUuid(), (Object)entryDN);
        }
    }

    @Override
    public void update(LDAPObject ldapObject) {
        BasicAttributes updatedAttributes = this.extractAttributes(ldapObject, false);
        NamingEnumeration<Attribute> attributes = updatedAttributes.getAll();
        String entryDn = ldapObject.getDn().toString();
        this.operationManager.modifyAttributes(entryDn, attributes);
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] and DN [%s] successfully updated to LDAP store.", (Object)ldapObject.getUuid(), (Object)entryDn);
        }
    }

    @Override
    public void remove(LDAPObject ldapObject) {
        this.operationManager.removeEntry(ldapObject.getDn().toString());
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] and DN [%s] successfully removed from LDAP store.", (Object)ldapObject.getUuid(), (Object)ldapObject.getDn().toString());
        }
    }

    @Override
    public List<LDAPObject> fetchQueryResults(LDAPQuery identityQuery) {
        if (identityQuery.getSorting() != null && !identityQuery.getSorting().isEmpty()) {
            throw new ModelException("LDAP Identity Store does not yet support sorted queries.");
        }
        ArrayList<LDAPObject> results = new ArrayList<LDAPObject>();
        try {
            String baseDN = identityQuery.getSearchDn();
            for (Condition condition : identityQuery.getConditions()) {
                EqualCondition equalCondition;
                SearchResult search;
                String uuidAttrName = this.getConfig().getUuidLDAPAttributeName();
                if (condition.getParameter() == null || !condition.getParameter().getName().equalsIgnoreCase(uuidAttrName)) continue;
                if (EqualCondition.class.isInstance(condition) && (search = this.operationManager.lookupById(baseDN, (equalCondition = (EqualCondition)condition).getValue().toString(), identityQuery.getReturningLdapAttributes())) != null) {
                    results.add(this.populateAttributedType(search, identityQuery));
                }
                return results;
            }
            StringBuilder filter = this.createIdentityTypeSearchFilter(identityQuery);
            List<SearchResult> search = this.getConfig().isPagination() && identityQuery.getLimit() > 0 ? this.operationManager.searchPaginated(baseDN, filter.toString(), identityQuery) : this.operationManager.search(baseDN, filter.toString(), identityQuery.getReturningLdapAttributes(), identityQuery.getSearchScope());
            for (SearchResult result : search) {
                if (result.getNameInNamespace().equalsIgnoreCase(baseDN)) continue;
                results.add(this.populateAttributedType(result, identityQuery));
            }
        }
        catch (Exception e) {
            throw new ModelException("Querying of LDAP failed " + identityQuery, (Throwable)e);
        }
        return results;
    }

    @Override
    public int countQueryResults(LDAPQuery identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    @Override
    public boolean validatePassword(LDAPObject user, String password) {
        String userDN = user.getDn().toString();
        if (logger.isTraceEnabled()) {
            logger.tracef("Using DN [%s] for authentication of user", (Object)userDN);
        }
        return this.operationManager.authenticate(userDN, password);
    }

    @Override
    public void updatePassword(LDAPObject user, String password) {
        String userDN = user.getDn().toString();
        if (logger.isDebugEnabled()) {
            logger.debugf("Using DN [%s] for updating LDAP password of user", (Object)userDN);
        }
        if (this.getConfig().isActiveDirectory()) {
            this.updateADPassword(userDN, password);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute("userpassword", password);
                mods[0] = new ModificationItem(2, mod0);
                this.operationManager.modifyAttribute(userDN, mod0);
            }
            catch (Exception e) {
                throw new ModelException("Error updating password.", (Throwable)e);
            }
        }
    }

    private void updateADPassword(String userDN, String password) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
            modItems.add(new ModificationItem(2, unicodePwd));
            if (this.getConfig().isUserAccountControlsAfterPasswordUpdate()) {
                BasicAttribute userAccountControl = new BasicAttribute("userAccountControl", "512");
                modItems.add(new ModificationItem(2, userAccountControl));
                logger.debugf("Attribute userAccountControls will be switched to 512 after password update of user [%s]", (Object)userDN);
            }
            this.operationManager.modifyAttributes(userDN, modItems.toArray(new ModificationItem[0]));
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e);
        }
    }

    protected StringBuilder createIdentityTypeSearchFilter(LDAPQuery identityQuery) {
        StringBuilder filter = new StringBuilder();
        for (Condition condition : identityQuery.getConditions()) {
            this.applyCondition(filter, condition);
        }
        filter.insert(0, "(&");
        filter.append((CharSequence)this.getObjectClassesFilter(identityQuery.getObjectClasses()));
        filter.append(")");
        if (logger.isTraceEnabled()) {
            logger.tracef("Using filter for LDAP search: %s . Searching in DN: %s", (Object)filter, (Object)identityQuery.getSearchDn());
        }
        return filter;
    }

    protected void applyCondition(StringBuilder filter, Condition condition) {
        String attributeName;
        if (OrCondition.class.isInstance(condition)) {
            OrCondition orCondition = (OrCondition)condition;
            filter.append("(|");
            for (Condition innerCondition : orCondition.getInnerConditions()) {
                this.applyCondition(filter, innerCondition);
            }
            filter.append(")");
            return;
        }
        QueryParameter queryParameter = condition.getParameter();
        if (!this.getConfig().getUuidLDAPAttributeName().equalsIgnoreCase(queryParameter.getName()) && (attributeName = queryParameter.getName()) != null) {
            if (EqualCondition.class.isInstance(condition)) {
                EqualCondition equalCondition = (EqualCondition)condition;
                Object parameterValue = equalCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                filter.append("(").append(attributeName).append("=").append(parameterValue).append(")");
            } else if (GreaterThanCondition.class.isInstance(condition)) {
                GreaterThanCondition greaterThanCondition = (GreaterThanCondition)condition;
                Object parameterValue = greaterThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (greaterThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append(">=").append(parameterValue).append(")");
                } else {
                    filter.append("(").append(attributeName).append(">").append(parameterValue).append(")");
                }
            } else if (LessThanCondition.class.isInstance(condition)) {
                LessThanCondition lessThanCondition = (LessThanCondition)condition;
                Object parameterValue = lessThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (lessThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append("<=").append(parameterValue).append(")");
                } else {
                    filter.append("(").append(attributeName).append("<").append(parameterValue).append(")");
                }
            } else if (BetweenCondition.class.isInstance(condition)) {
                BetweenCondition betweenCondition = (BetweenCondition)condition;
                Object x = betweenCondition.getX();
                Object y = betweenCondition.getY();
                if (Date.class.isInstance(x)) {
                    x = LDAPUtil.formatDate((Date)x);
                }
                if (Date.class.isInstance(y)) {
                    y = LDAPUtil.formatDate((Date)y);
                }
                filter.append("(").append(x).append("<=").append(attributeName).append("<=").append(y).append(")");
            } else if (InCondition.class.isInstance(condition)) {
                InCondition inCondition = (InCondition)condition;
                Object[] valuesToCompare = inCondition.getValue();
                filter.append("(&(");
                for (int i = 0; i < valuesToCompare.length; ++i) {
                    Object value = valuesToCompare[i];
                    filter.append("(").append(attributeName).append("=").append(value).append(")");
                }
                filter.append("))");
            } else {
                throw new ModelException("Unsupported query condition [" + condition + "].");
            }
        }
    }

    private StringBuilder getObjectClassesFilter(Collection<String> objectClasses) {
        StringBuilder builder = new StringBuilder();
        if (!objectClasses.isEmpty()) {
            for (String objectClass : objectClasses) {
                builder.append("(").append("objectclass").append("=").append(objectClass).append(")");
            }
        } else {
            builder.append("(").append("objectclass").append("=").append("*").append(")");
        }
        return builder;
    }

    private LDAPObject populateAttributedType(SearchResult searchResult, LDAPQuery ldapQuery) {
        Set<String> readOnlyAttrNames = ldapQuery.getReturningReadOnlyLdapAttributes();
        TreeSet<String> lowerCasedAttrNames = new TreeSet<String>();
        for (String attrName : ldapQuery.getReturningLdapAttributes()) {
            lowerCasedAttrNames.add(attrName.toLowerCase());
        }
        try {
            String entryDN = searchResult.getNameInNamespace();
            Attributes attributes = searchResult.getAttributes();
            LDAPObject ldapObject = new LDAPObject();
            LDAPDn dn = LDAPDn.fromString(entryDN);
            ldapObject.setDn(dn);
            ldapObject.setRdnAttributeName(dn.getFirstRdnAttrName());
            NamingEnumeration<? extends Attribute> ldapAttributes = attributes.getAll();
            while (ldapAttributes.hasMore()) {
                Attribute ldapAttribute = ldapAttributes.next();
                try {
                    ldapAttribute.get();
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                String ldapAttributeName = ldapAttribute.getID();
                if (ldapAttributeName.equalsIgnoreCase(this.getConfig().getUuidLDAPAttributeName())) {
                    Object uuidValue = ldapAttribute.get();
                    ldapObject.setUuid(this.operationManager.decodeEntryUUID(uuidValue));
                }
                if (ldapAttributeName.equalsIgnoreCase(this.getConfig().getUuidLDAPAttributeName()) && !lowerCasedAttrNames.contains(ldapAttributeName.toLowerCase())) continue;
                LinkedHashSet<String> attrValues = new LinkedHashSet<String>();
                NamingEnumeration<?> enumm = ldapAttribute.getAll();
                while (enumm.hasMoreElements()) {
                    String attrVal = enumm.next().toString().trim();
                    attrValues.add(attrVal);
                }
                if (ldapAttributeName.equalsIgnoreCase("objectclass")) {
                    ldapObject.setObjectClasses(attrValues);
                    continue;
                }
                ldapObject.setAttribute(ldapAttributeName, attrValues);
                if (!readOnlyAttrNames.contains(ldapAttributeName.toLowerCase())) continue;
                ldapObject.addReadOnlyAttributeName(ldapAttributeName);
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Found ldap object [%s] and populated with the attributes [%s]. Read-only attributes are [%s]", (Object)ldapObject.getDn().toString(), ldapObject.getAttributes(), ldapObject.getReadOnlyAttributeNames());
            }
            return ldapObject;
        }
        catch (Exception e) {
            throw new ModelException("Could not populate attribute type " + searchResult.getNameInNamespace() + ".", (Throwable)e);
        }
    }

    protected BasicAttributes extractAttributes(LDAPObject ldapObject, boolean isCreate) {
        BasicAttributes entryAttributes = new BasicAttributes();
        for (Map.Entry<String, Set<String>> attrEntry : ldapObject.getAttributes().entrySet()) {
            String attrName = attrEntry.getKey();
            Set<String> attrValue = attrEntry.getValue();
            if (ldapObject.getReadOnlyAttributeNames().contains(attrName.toLowerCase()) || !isCreate && ldapObject.getRdnAttributeName().equalsIgnoreCase(attrName)) continue;
            if (attrValue == null) {
                logger.warnf("Attribute '%s' is null on LDAP object '%s' . Using empty value to be saved to LDAP", (Object)attrName, (Object)ldapObject.getDn().toString());
                attrValue = Collections.emptySet();
            }
            if (isCreate && attrValue.isEmpty()) continue;
            BasicAttribute attr = new BasicAttribute(attrName);
            for (String val : attrValue) {
                if (val == null || val.toString().trim().length() == 0) {
                    val = " ";
                }
                attr.add(val);
            }
            entryAttributes.put(attr);
        }
        if (isCreate) {
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            for (String objectClassValue : ldapObject.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
                if (!objectClassValue.equalsIgnoreCase("groupOfNames") && !objectClassValue.equalsIgnoreCase("groupOfEntries") && !objectClassValue.equalsIgnoreCase("groupOfUniqueNames")) continue;
                entryAttributes.put("member", "cn=empty-membership-placeholder");
            }
            entryAttributes.put(objectClassAttribute);
        }
        return entryAttributes;
    }

    protected String getEntryIdentifier(LDAPObject ldapObject) {
        try {
            String uuidAttrName = this.getConfig().getUuidLDAPAttributeName();
            List<SearchResult> search = this.operationManager.search(ldapObject.getDn().toString(), "(" + ldapObject.getDn().getFirstRdn() + ")", Arrays.asList(uuidAttrName), 0);
            Attribute id = search.get(0).getAttributes().get(this.getConfig().getUuidLDAPAttributeName());
            if (id == null) {
                throw new ModelException("Could not retrieve identifier for entry [" + ldapObject.getDn().toString() + "].");
            }
            return this.operationManager.decodeEntryUUID(id.get());
        }
        catch (NamingException ne) {
            throw new ModelException("Could not retrieve identifier for entry [" + ldapObject.getDn().toString() + "].");
        }
    }
}

